/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;

public final class OldPackageFacadeClassUtils {
    private static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";

    private OldPackageFacadeClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN.isRoot()) {
            return DEFAULT_PACKAGE_CLASS_NAME;
        }
        return OldPackageFacadeClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

