/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.tree.IElementType;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;

public class KtNodeType
extends IElementType {
    private final Constructor<? extends KtElement> myPsiFactory;

    public KtNodeType(@NotNull @NonNls String debugName, Class<? extends KtElement> psiClass) {
        super(debugName, (Language)KotlinLanguage.INSTANCE);
        try {
            this.myPsiFactory = psiClass != null ? psiClass.getConstructor(ASTNode.class) : null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Must have a constructor with ASTNode");
        }
    }

    public KtElement createPsi(ASTNode node) {
        assert (node.getElementType() == this);
        try {
            if (this.myPsiFactory == null) {
                return new KtElementImpl(node);
            }
            return this.myPsiFactory.newInstance(node);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating psi element for node", e);
        }
    }

    public static class KtLeftBoundNodeType
    extends KtNodeType {
        public KtLeftBoundNodeType(@NotNull @NonNls String debugName, Class<? extends KtElement> psiClass) {
            super(debugName, psiClass);
        }

        public boolean isLeftBound() {
            return true;
        }
    }
}

