/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintingLogger
extends Logger {
    public static final Logger SYSTEM_OUT = new PrintingLogger(System.out);
    public static final Logger SYSTEM_ERR = new PrintingLogger(System.err);
    private final PrintStream out;

    public PrintingLogger(@NotNull PrintStream out) {
        this.out = out;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(@NonNls String message) {
        this.out.println(message);
    }

    public void debug(@Nullable Throwable t) {
        t.printStackTrace(this.out);
    }

    public void debug(@NonNls String message, @Nullable Throwable t) {
        this.debug(message);
        this.debug(t);
    }

    public void info(@NonNls String message) {
        this.debug(message);
    }

    public void info(@NonNls String message, @Nullable Throwable t) {
        this.debug(message, t);
    }

    public void warn(@NonNls String message, @Nullable Throwable t) {
        this.debug(message, t);
    }

    public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
        this.debug(message, t);
        for (String detail : details) {
            this.debug(detail);
        }
    }

    public void setLevel(Level level) {
    }
}

