/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticsElementsCache {
    private final Diagnostics diagnostics;
    private final Function1<Diagnostic, Boolean> filter;
    private final AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>> elementToDiagnostic = new AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>>(){

        @NotNull
        protected MultiMap<PsiElement, Diagnostic> compute() {
            return DiagnosticsElementsCache.buildElementToDiagnosticCache(DiagnosticsElementsCache.this.diagnostics, (Function1<Diagnostic, Boolean>)DiagnosticsElementsCache.this.filter);
        }
    };

    public DiagnosticsElementsCache(Diagnostics diagnostics2, Function1<Diagnostic, Boolean> filter2) {
        this.diagnostics = diagnostics2;
        this.filter = filter2;
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics(@NotNull PsiElement psiElement) {
        return ((MultiMap)this.elementToDiagnostic.getValue()).get((Object)psiElement);
    }

    private static MultiMap<PsiElement, Diagnostic> buildElementToDiagnosticCache(Diagnostics diagnostics2, Function1<Diagnostic, Boolean> filter2) {
        ConcurrentMultiMap elementToDiagnostic = new ConcurrentMultiMap();
        for (Diagnostic diagnostic : diagnostics2) {
            if (diagnostic == null) {
                throw new IllegalStateException("There shouldn't be null diagnostics in the collection: " + CollectionsKt.toList((Iterable)diagnostics2));
            }
            if (!((Boolean)filter2.invoke((Object)diagnostic)).booleanValue()) continue;
            elementToDiagnostic.putValue((Object)diagnostic.getPsiElement(), (Object)diagnostic);
        }
        return elementToDiagnostic;
    }
}

