/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing.effects;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.parsing.AbstractPsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/effects/PsiReturnsEffectParser;", "Lorg/jetbrains/kotlin/contracts/parsing/AbstractPsiEffectParser;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "contractParserDispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "tryParseEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
public final class PsiReturnsEffectParser
extends AbstractPsiEffectParser {
    @Override
    @Nullable
    public EffectDeclaration tryParseEffect(@NotNull KtExpression expression2) {
        ConstantReference constantReference;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        if (PsiContractsUtilsKt.isReturnsNotNullDescriptor(descriptor2)) {
            return new ReturnsEffectDeclaration(ConstantReference.Companion.getNOT_NULL());
        }
        if (!PsiContractsUtilsKt.isReturnsEffectDescriptor(descriptor2)) {
            return null;
        }
        KtExpression argumentExpression = PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3);
        if (argumentExpression == null) {
            constantReference = ConstantReference.Companion.getWILDCARD();
        } else {
            ConstantReference constant = this.getContractParserDispatcher().parseConstant(argumentExpression);
            if (constant == null) {
                this.getTrace().report(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)argumentExpression), "only true/false/null constants in Returns-effect are currently supported"));
                return null;
            }
            constantReference = constant;
        }
        ConstantReference constantValue = constantReference;
        return new ReturnsEffectDeclaration(constantValue);
    }

    public PsiReturnsEffectParser(@NotNull BindingTrace trace, @NotNull PsiContractParserDispatcher contractParserDispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)contractParserDispatcher, (String)"contractParserDispatcher");
        super(trace, contractParserDispatcher);
    }
}

