/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantGotoMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "getLastTargetJumpInsn", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "jumpInsn", "labelsToReplace", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "alreadyVisited", "", "rewriteLabelIfNeeded", "", "transform", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "backend"})
public final class RedundantGotoMethodTransformer
extends MethodTransformer {
    /*
     * WARNING - void declaration
     */
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Object[] $receiver = objectArray = methodNode.instructions.toArray();
        ArraysKt.reverse((Object[])$receiver);
        Object[] insns2 = objectArray;
        ArrayList<Object> insnsToRemove = new ArrayList<Object>();
        HashSet<Object> currentLabels = new HashSet<Object>();
        HashMap labelsToReplace = new HashMap();
        JumpInsnNode pendingGoto = null;
        int n = insns2.length;
        for (int i = 0; i < n; ++i) {
            Object object = insns2[i];
            if (object instanceof LabelNode) {
                currentLabels.add(object);
                if (pendingGoto != null) {
                    JumpInsnNode jumpInsnNode;
                    JumpInsnNode it = jumpInsnNode;
                    Map map2 = labelsToReplace;
                    Object object2 = object;
                    JumpInsnNode jumpInsnNode2 = it;
                    map2.put(object2, jumpInsnNode2);
                }
                continue;
            }
            Object object3 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"insn");
            if (object3.getOpcode() == 167) {
                pendingGoto = (JumpInsnNode)object;
                if (currentLabels.contains(((JumpInsnNode)object).label)) {
                    insnsToRemove.add(object);
                    continue;
                }
                currentLabels.clear();
                continue;
            }
            if (object instanceof LineNumberNode) {
                pendingGoto = null;
                continue;
            }
            if (!UtilKt.isMeaningful((AbstractInsnNode)object)) continue;
            currentLabels.clear();
            pendingGoto = null;
        }
        if (!labelsToReplace.isEmpty()) {
            void $receiver$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)insns2, (String)"insns");
            Object[] objectArray2 = insns2;
            Object[] object = objectArray2;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof JumpInsnNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            for (Object element$iv : iterable) {
                JumpInsnNode it = (JumpInsnNode)element$iv;
                this.rewriteLabelIfNeeded(it, labelsToReplace);
            }
        }
        for (AbstractInsnNode abstractInsnNode : insnsToRemove) {
            methodNode.instructions.remove(abstractInsnNode);
        }
    }

    private final void rewriteLabelIfNeeded(JumpInsnNode jumpInsn, Map<LabelNode, ? extends JumpInsnNode> labelsToReplace) {
        RedundantGotoMethodTransformer redundantGotoMethodTransformer = this;
        JumpInsnNode jumpInsnNode = jumpInsn;
        Map<LabelNode, ? extends JumpInsnNode> map2 = labelsToReplace;
        List list2 = new ArrayList();
        JumpInsnNode lastJumpInsn = redundantGotoMethodTransformer.getLastTargetJumpInsn(jumpInsnNode, map2, list2);
        if (lastJumpInsn != null && Intrinsics.areEqual((Object)lastJumpInsn, (Object)jumpInsn) ^ true) {
            jumpInsn.label = lastJumpInsn.label;
        }
    }

    private final JumpInsnNode getLastTargetJumpInsn(JumpInsnNode jumpInsn, Map<LabelNode, ? extends JumpInsnNode> labelsToReplace, List<JumpInsnNode> alreadyVisited) {
        JumpInsnNode jumpInsnNode = labelsToReplace.get(jumpInsn.label);
        if (jumpInsnNode != null) {
            JumpInsnNode jumpInsnNode2 = jumpInsnNode;
            JumpInsnNode it = jumpInsnNode2;
            if (alreadyVisited.contains(it)) {
                return null;
            }
            alreadyVisited.add(it);
            return this.getLastTargetJumpInsn(it, labelsToReplace, alreadyVisited);
        }
        return jumpInsn;
    }
}

