/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static final Map<String, String> ourGlobalMacros = ContainerUtil.immutableMapBuilder().put((Object)"APPLICATION_HOME_DIR", (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getHomePath())).put((Object)"APPLICATION_CONFIG_DIR", (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath())).put((Object)"APPLICATION_PLUGINS_DIR", (Object)FileUtilRt.toSystemIndependentName((String)PathManager.getPluginsPath())).put((Object)"USER_HOME", (Object)StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/")).build();

    @Nullable
    public static String getModuleDir(@NotNull String moduleFilePath) {
        String moduleDir;
        if (moduleFilePath == null) {
            PathMacroUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(moduleDir = PathUtilRt.getParentPath((String)moduleFilePath)))) {
            return null;
        }
        String moduleDirParent = PathUtilRt.getParentPath((String)moduleDir);
        if (!StringUtil.isEmpty((String)moduleDirParent) && PathUtilRt.getFileName((String)moduleDir).equals(DIRECTORY_STORE_NAME)) {
            moduleDir = moduleDirParent;
        }
        if ((moduleDir = FileUtilRt.toSystemIndependentName((String)moduleDir)).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    @NotNull
    public static String getUserHomePath() {
        String string = (String)ObjectUtils.assertNotNull((Object)PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
        if (string == null) {
            PathMacroUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros() {
        Map<String, String> map2 = ourGlobalMacros;
        if (map2 == null) {
            PathMacroUtil.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name) {
        return ourGlobalMacros.get(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHomePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalSystemMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDir";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

