/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "hasBackingField", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasCustomAccessor", "isInsideCompanionObjectOfInterface", "Problem", "frontend.java"})
public final class JvmFieldApplicabilityChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Problem problem;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        AnnotationDescriptor annotationDescriptor = AnnotationUtilKt.findJvmFieldAnnotation(descriptor2);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        if (declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate()) {
            problem = Problem.DELEGATE;
        } else {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
            if (!this.hasBackingField(propertyDescriptor, bindingContext)) {
                return;
            }
            if (ModalityKt.isOverridable((CallableMemberDescriptor)descriptor2)) {
                problem = Problem.NOT_FINAL;
            } else if (Visibilities.isPrivate(((PropertyDescriptor)descriptor2).getVisibility())) {
                problem = Problem.PRIVATE;
            } else if (this.hasCustomAccessor((PropertyDescriptor)descriptor2)) {
                problem = Problem.CUSTOM_ACCESSOR;
            } else {
                Collection<? extends PropertyDescriptor> collection = ((PropertyDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
                Collection<? extends PropertyDescriptor> collection2 = collection;
                if (!collection2.isEmpty()) {
                    problem = Problem.OVERRIDES;
                } else if (((PropertyDescriptor)descriptor2).isLateInit()) {
                    problem = Problem.LATEINIT;
                } else if (((PropertyDescriptor)descriptor2).isConst()) {
                    problem = Problem.CONST;
                } else if (this.isInsideCompanionObjectOfInterface((PropertyDescriptor)descriptor2)) {
                    problem = Problem.INSIDE_COMPANION_OF_INTERFACE;
                } else if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration)) {
                    problem = Problem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                } else {
                    return;
                }
            }
        }
        Problem problem2 = problem;
        AnnotationDescriptor annotationDescriptor2 = annotation2;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationDescriptor2, (String)"annotation");
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor2);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        context.getTrace().report(ErrorsJvm.INAPPLICABLE_JVM_FIELD.on((KtAnnotationEntry)((PsiElement)annotationEntry), problem2.getErrorMessage()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasCustomAccessor(@NotNull PropertyDescriptor $receiver) {
        PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
        if (!(propertyGetterDescriptor != null ? propertyGetterDescriptor.isDefault() : true)) return true;
        PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
        if (propertySetterDescriptor == null) return false;
        boolean bl = propertySetterDescriptor.isDefault();
        if (bl) return false;
        return true;
    }

    private final boolean hasBackingField(@NotNull PropertyDescriptor $receiver, BindingContext bindingContext) {
        Boolean bl = (Boolean)bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, $receiver);
        return bl != null ? bl : false;
    }

    private final boolean isInsideCompanionObjectOfInterface(@NotNull PropertyDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (!DescriptorUtils.isCompanionObject(containingClass)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingClass.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
        ClassKind outerClassKind = classDescriptor2 != null ? classDescriptor2.getKind() : null;
        return outerClassKind == ClassKind.INTERFACE || outerClassKind == ClassKind.ANNOTATION_CLASS;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker$Problem;", "", "errorMessage", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "NOT_FINAL", "PRIVATE", "CUSTOM_ACCESSOR", "OVERRIDES", "LATEINIT", "CONST", "INSIDE_COMPANION_OF_INTERFACE", "TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE", "DELEGATE", "frontend.java"})
    public static final class Problem
    extends Enum<Problem> {
        public static final /* enum */ Problem NOT_FINAL;
        public static final /* enum */ Problem PRIVATE;
        public static final /* enum */ Problem CUSTOM_ACCESSOR;
        public static final /* enum */ Problem OVERRIDES;
        public static final /* enum */ Problem LATEINIT;
        public static final /* enum */ Problem CONST;
        public static final /* enum */ Problem INSIDE_COMPANION_OF_INTERFACE;
        public static final /* enum */ Problem TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
        public static final /* enum */ Problem DELEGATE;
        private static final /* synthetic */ Problem[] $VALUES;
        @NotNull
        private final String errorMessage;

        static {
            Problem[] problemArray = new Problem[9];
            Problem[] problemArray2 = problemArray;
            problemArray[0] = NOT_FINAL = new Problem("JvmField can only be applied to final property");
            problemArray[1] = PRIVATE = new Problem("JvmField has no effect on a private property");
            problemArray[2] = CUSTOM_ACCESSOR = new Problem("JvmField cannot be applied to a property with a custom accessor");
            problemArray[3] = OVERRIDES = new Problem("JvmField cannot be applied to a property that overrides some other property");
            problemArray[4] = LATEINIT = new Problem("JvmField cannot be applied to lateinit property");
            problemArray[5] = CONST = new Problem("JvmField cannot be applied to const property");
            problemArray[6] = INSIDE_COMPANION_OF_INTERFACE = new Problem("JvmField cannot be applied to a property defined in companion object of interface");
            problemArray[7] = TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE = new Problem("JvmField cannot be applied to top level property of a file annotated with " + JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT());
            problemArray[8] = DELEGATE = new Problem("JvmField cannot be applied to delegated property");
            $VALUES = problemArray;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        protected Problem(String errorMessage) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            this.errorMessage = errorMessage;
        }

        public static Problem[] values() {
            return (Problem[])$VALUES.clone();
        }

        public static Problem valueOf(String string) {
            return Enum.valueOf(Problem.class, string);
        }
    }
}

