/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.impl.ClassNamesUtilKt;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;

public class JavaClassifierTypeImpl
extends JavaTypeImpl<PsiClassType>
implements JavaClassifierType {
    private ResolutionResult resolutionResult;

    public JavaClassifierTypeImpl(@NotNull PsiClassType psiClassType) {
        super(psiClassType);
    }

    @Override
    @Nullable
    public JavaClassifierImpl<?> getClassifier() {
        this.resolve();
        return this.resolutionResult.classifier;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        this.resolve();
        return this.resolutionResult.substitutor;
    }

    private void resolve() {
        if (this.resolutionResult == null) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)this.getPsi()).resolveGenerics();
            PsiClass psiClass = result2.getElement();
            PsiSubstitutor substitutor2 = result2.getSubstitutor();
            this.resolutionResult = new ResolutionResult(psiClass == null ? null : JavaClassifierImpl.create(psiClass), substitutor2, PsiClassType.isRaw((PsiClassType.ClassResolveResult)result2));
        }
    }

    @Override
    @NotNull
    public String getClassifierQualifiedName() {
        return ClassNamesUtilKt.convertCanonicalNameToQName(((PsiClassType)this.getPsi()).getCanonicalText());
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return ((PsiClassType)this.getPsi()).getPresentableText();
    }

    @Override
    public boolean isRaw() {
        this.resolve();
        return this.resolutionResult.isRaw;
    }

    @Override
    @NotNull
    public List<JavaType> getTypeArguments() {
        JavaClassifier classifier2 = this.getClassifier();
        if (!(classifier2 instanceof JavaClassImpl)) {
            return Collections.emptyList();
        }
        List<PsiTypeParameter> parameters2 = JavaClassifierTypeImpl.getTypeParameters((PsiClass)((JavaElementImpl)((Object)classifier2)).getPsi());
        PsiSubstitutor substitutor2 = this.getSubstitutor();
        ArrayList<JavaType> result2 = new ArrayList<JavaType>(parameters2.size());
        for (PsiTypeParameter typeParameter : parameters2) {
            PsiType substitutedType = substitutor2.substitute(typeParameter);
            result2.add(substitutedType == null ? null : JavaTypeImpl.create(substitutedType));
        }
        return result2;
    }

    @NotNull
    private static List<PsiTypeParameter> getTypeParameters(@NotNull PsiClass owner) {
        ArrayList result2 = null;
        for (PsiClass currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters2 = currentOwner.getTypeParameters();
            if (typeParameters2.length > 0) {
                if (result2 == null) {
                    result2 = new ArrayList(typeParameters2.length);
                }
                Collections.addAll(result2, typeParameters2);
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result2 == null) {
            return Collections.emptyList();
        }
        return result2;
    }

    private static class ResolutionResult {
        private final JavaClassifierImpl<?> classifier;
        private final PsiSubstitutor substitutor;
        private final boolean isRaw;

        private ResolutionResult(@Nullable JavaClassifierImpl<?> classifier2, @NotNull PsiSubstitutor substitutor2, boolean isRaw) {
            this.classifier = classifier2;
            this.substitutor = substitutor2;
            this.isRaw = isRaw;
        }
    }
}

