/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

public class IOUtil {
    static final int IOV_MAX;

    private IOUtil() {
    }

    static int write(FileDescriptor fd, ByteBuffer src, long position, NativeDispatcher nd) throws IOException {
        return IOUtil.write(fd, src, position, false, -1, nd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fd, ByteBuffer src, long position, boolean directIO, int alignment, NativeDispatcher nd) throws IOException {
        ByteBuffer bb;
        int rem;
        if (src instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fd, src, position, directIO, alignment, nd);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (directIO) {
            Util.checkRemainingBufferSizeAligned(rem, alignment);
            bb = Util.getTemporaryAlignedDirectBuffer(rem, alignment);
        } else {
            bb = Util.getTemporaryDirectBuffer(rem);
        }
        try {
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n2 = IOUtil.writeFromNativeBuffer(fd, bb, position, directIO, alignment, nd);
            if (n2 > 0) {
                src.position(pos + n2);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(bb);
        }
    }

    private static int writeFromNativeBuffer(FileDescriptor fd, ByteBuffer bb, long position, boolean directIO, int alignment, NativeDispatcher nd) throws IOException {
        int rem;
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (directIO) {
            Util.checkBufferPositionAligned(bb, pos, alignment);
            Util.checkRemainingBufferSizeAligned(rem, alignment);
        }
        int written = 0;
        if (rem == 0) {
            return 0;
        }
        written = position != -1L ? nd.pwrite(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, position) : nd.write(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem);
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    static long write(FileDescriptor fd, ByteBuffer[] bufs, NativeDispatcher nd) throws IOException {
        return IOUtil.write(fd, bufs, 0, bufs.length, false, -1, nd);
    }

    static long write(FileDescriptor fd, ByteBuffer[] bufs, int offset, int length, NativeDispatcher nd) throws IOException {
        return IOUtil.write(fd, bufs, offset, length, false, -1, nd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fd, ByteBuffer[] bufs, int offset, int length, boolean directIO, int alignment, NativeDispatcher nd) throws IOException {
        IOVecWrapper vec = IOVecWrapper.get(length);
        boolean completed = false;
        int iov_len = 0;
        try {
            long bytesWritten;
            int count = offset + length;
            for (int i = offset; i < count && iov_len < IOV_MAX; ++i) {
                int rem;
                ByteBuffer buf = bufs[i];
                int pos = buf.position();
                int lim = buf.limit();
                assert (pos <= lim);
                int n = rem = pos <= lim ? lim - pos : 0;
                if (directIO) {
                    Util.checkRemainingBufferSizeAligned(rem, alignment);
                }
                if (rem <= 0) continue;
                vec.setBuffer(iov_len, buf, pos, rem);
                if (!(buf instanceof DirectBuffer)) {
                    ByteBuffer shadow = directIO ? Util.getTemporaryAlignedDirectBuffer(rem, alignment) : Util.getTemporaryDirectBuffer(rem);
                    shadow.put(buf);
                    shadow.flip();
                    vec.setShadow(iov_len, shadow);
                    buf.position(pos);
                    buf = shadow;
                    pos = shadow.position();
                }
                vec.putBase(iov_len, ((DirectBuffer)((Object)buf)).address() + (long)pos);
                vec.putLen(iov_len, rem);
                ++iov_len;
            }
            if (iov_len == 0) {
                long buf = 0L;
                return buf;
            }
            long left = bytesWritten = nd.writev(fd, vec.address, iov_len);
            for (int j = 0; j < iov_len; ++j) {
                ByteBuffer shadow;
                if (left > 0L) {
                    ByteBuffer buf = vec.getBuffer(j);
                    int pos = vec.getPosition(j);
                    int rem = vec.getRemaining(j);
                    int n = left > (long)rem ? rem : (int)left;
                    buf.position(pos + n);
                    left -= (long)n;
                }
                if ((shadow = vec.getShadow(j)) != null) {
                    Util.offerLastTemporaryDirectBuffer(shadow);
                }
                vec.clearRefs(j);
            }
            completed = true;
            long l = bytesWritten;
            return l;
        }
        finally {
            if (!completed) {
                for (int j = 0; j < iov_len; ++j) {
                    ByteBuffer shadow = vec.getShadow(j);
                    if (shadow != null) {
                        Util.offerLastTemporaryDirectBuffer(shadow);
                    }
                    vec.clearRefs(j);
                }
            }
        }
    }

    static int read(FileDescriptor fd, ByteBuffer dst, long position, NativeDispatcher nd) throws IOException {
        return IOUtil.read(fd, dst, position, false, -1, nd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fd, ByteBuffer dst, long position, boolean directIO, int alignment, NativeDispatcher nd) throws IOException {
        ByteBuffer bb;
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (dst instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fd, dst, position, directIO, alignment, nd);
        }
        int rem = dst.remaining();
        if (directIO) {
            Util.checkRemainingBufferSizeAligned(rem, alignment);
            bb = Util.getTemporaryAlignedDirectBuffer(rem, alignment);
        } else {
            bb = Util.getTemporaryDirectBuffer(rem);
        }
        try {
            int n = IOUtil.readIntoNativeBuffer(fd, bb, position, directIO, alignment, nd);
            bb.flip();
            if (n > 0) {
                dst.put(bb);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(bb);
        }
    }

    private static int readIntoNativeBuffer(FileDescriptor fd, ByteBuffer bb, long position, boolean directIO, int alignment, NativeDispatcher nd) throws IOException {
        int rem;
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (directIO) {
            Util.checkBufferPositionAligned(bb, pos, alignment);
            Util.checkRemainingBufferSizeAligned(rem, alignment);
        }
        if (rem == 0) {
            return 0;
        }
        int n2 = 0;
        n2 = position != -1L ? nd.pread(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, position) : nd.read(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem);
        if (n2 > 0) {
            bb.position(pos + n2);
        }
        return n2;
    }

    static long read(FileDescriptor fd, ByteBuffer[] bufs, NativeDispatcher nd) throws IOException {
        return IOUtil.read(fd, bufs, 0, bufs.length, false, -1, nd);
    }

    static long read(FileDescriptor fd, ByteBuffer[] bufs, int offset, int length, NativeDispatcher nd) throws IOException {
        return IOUtil.read(fd, bufs, offset, length, false, -1, nd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fd, ByteBuffer[] bufs, int offset, int length, boolean directIO, int alignment, NativeDispatcher nd) throws IOException {
        IOVecWrapper vec = IOVecWrapper.get(length);
        boolean completed = false;
        int iov_len = 0;
        try {
            long bytesRead;
            int count = offset + length;
            for (int i = offset; i < count && iov_len < IOV_MAX; ++i) {
                int rem;
                ByteBuffer buf = bufs[i];
                if (buf.isReadOnly()) {
                    throw new IllegalArgumentException("Read-only buffer");
                }
                int pos = buf.position();
                int lim = buf.limit();
                assert (pos <= lim);
                int n = rem = pos <= lim ? lim - pos : 0;
                if (directIO) {
                    Util.checkRemainingBufferSizeAligned(rem, alignment);
                }
                if (rem <= 0) continue;
                vec.setBuffer(iov_len, buf, pos, rem);
                if (!(buf instanceof DirectBuffer)) {
                    ByteBuffer shadow = directIO ? Util.getTemporaryAlignedDirectBuffer(rem, alignment) : Util.getTemporaryDirectBuffer(rem);
                    vec.setShadow(iov_len, shadow);
                    buf = shadow;
                    pos = shadow.position();
                }
                vec.putBase(iov_len, ((DirectBuffer)((Object)buf)).address() + (long)pos);
                vec.putLen(iov_len, rem);
                ++iov_len;
            }
            if (iov_len == 0) {
                long buf = 0L;
                return buf;
            }
            long left = bytesRead = nd.readv(fd, vec.address, iov_len);
            for (int j = 0; j < iov_len; ++j) {
                ByteBuffer shadow = vec.getShadow(j);
                if (left > 0L) {
                    int n;
                    ByteBuffer buf = vec.getBuffer(j);
                    int rem = vec.getRemaining(j);
                    int n2 = n = left > (long)rem ? rem : (int)left;
                    if (shadow == null) {
                        int pos = vec.getPosition(j);
                        buf.position(pos + n);
                    } else {
                        shadow.limit(shadow.position() + n);
                        buf.put(shadow);
                    }
                    left -= (long)n;
                }
                if (shadow != null) {
                    Util.offerLastTemporaryDirectBuffer(shadow);
                }
                vec.clearRefs(j);
            }
            completed = true;
            long l = bytesRead;
            return l;
        }
        finally {
            if (!completed) {
                for (int j = 0; j < iov_len; ++j) {
                    ByteBuffer shadow = vec.getShadow(j);
                    if (shadow != null) {
                        Util.offerLastTemporaryDirectBuffer(shadow);
                    }
                    vec.clearRefs(j);
                }
            }
        }
    }

    public static FileDescriptor newFD(int i) {
        FileDescriptor fd = new FileDescriptor();
        IOUtil.setfdVal(fd, i);
        return fd;
    }

    static native boolean randomBytes(byte[] var0);

    static native long makePipe(boolean var0) throws IOException;

    static native int write1(int var0, byte var1) throws IOException;

    static native boolean drain(int var0) throws IOException;

    static native int drain1(int var0) throws IOException;

    public static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    public static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native int fdLimit();

    static native int iovMax();

    static native void initIDs();

    public static void load() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                System.loadLibrary("nio");
                return null;
            }
        });
        IOUtil.initIDs();
        IOV_MAX = IOUtil.iovMax();
    }
}

