/*
 * Decompiled with CFR 0.152.
 */
package java.util.function;

import java.util.Objects;

@FunctionalInterface
public interface Predicate<T> {
    public boolean test(T var1);

    default public Predicate<T> and(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public Predicate<T> negate() {
        return t -> !this.test(t);
    }

    default public Predicate<T> or(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> Predicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
    }

    public static <T> Predicate<T> not(Predicate<? super T> target) {
        Objects.requireNonNull(target);
        return target.negate();
    }
}

