/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DesugarTimeUnit {
    private static final long NANO_SCALE = 1L;
    private static final long MICRO_SCALE = 1000L;
    private static final long MILLI_SCALE = 1000000L;
    private static final long SECOND_SCALE = 1000000000L;
    private static final long MINUTE_SCALE = 60000000000L;
    private static final long HOUR_SCALE = 3600000000000L;
    private static final long DAY_SCALE = 86400000000000L;

    private DesugarTimeUnit() {
    }

    public static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    public static TimeUnit of(ChronoUnit chronoUnit) {
        switch (Objects.requireNonNull(chronoUnit, "chronoUnit")) {
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("No TimeUnit equivalent for " + chronoUnit);
    }

    public static long convert(TimeUnit timeUnit, Duration duration) {
        return timeUnit.convert(duration.toNanos(), TimeUnit.NANOSECONDS);
    }
}

