/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import desugar.sun.nio.fs.DesugarGlobs;
import desugar.sun.nio.fs.DesugarLinuxFileSystemProvider;
import desugar.sun.nio.fs.DesugarUnixPath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DesugarLinuxFileSystem
extends FileSystem {
    public static final String SEPARATOR = "/";
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";
    private final String userDir;
    private final String rootDir;
    private final DesugarLinuxFileSystemProvider provider;

    public DesugarLinuxFileSystem(DesugarLinuxFileSystemProvider provider, String userDir, String rootDir) {
        this.provider = provider;
        this.userDir = userDir;
        this.rootDir = rootDir;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return SEPARATOR;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(new DesugarUnixPath(this, SEPARATOR, this.userDir, this.rootDir));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of("basic");
    }

    @Override
    public DesugarUnixPath getPath(String first, String ... more) {
        String path;
        if (more.length == 0) {
            path = first;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            for (String segment : more) {
                if (segment.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(segment);
            }
            path = sb.toString();
        }
        return new DesugarUnixPath(this, path, this.userDir, this.rootDir);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        String expr;
        int pos = syntaxAndPattern.indexOf(58);
        if (pos <= 0 || pos == syntaxAndPattern.length()) {
            throw new IllegalArgumentException(String.format("Requested <syntax>:<pattern> spliterator(':') position(%d) is out of bound in %s", pos, syntaxAndPattern));
        }
        String syntax = syntaxAndPattern.substring(0, pos);
        String input = syntaxAndPattern.substring(pos + 1);
        if (syntax.equalsIgnoreCase(GLOB_SYNTAX)) {
            expr = DesugarGlobs.toUnixRegexPattern(input);
        } else if (syntax.equalsIgnoreCase(REGEX_SYNTAX)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        Pattern pattern = Pattern.compile(expr);
        return path -> pattern.matcher(path.toString()).matches();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }
}

