/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

abstract class AbstractPoller
implements Runnable {
    private final LinkedList<Request> requestList = new LinkedList();
    private boolean shutdown = false;

    protected AbstractPoller() {
    }

    public void start() {
        final AbstractPoller thisRunnable = this;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread thr = new Thread(null, thisRunnable, "FileSystemWatchService", 0L, false);
                thr.setDaemon(true);
                thr.start();
                return null;
            }
        });
    }

    abstract void wakeup() throws IOException;

    abstract Object implRegister(Path var1, Set<? extends WatchEvent.Kind<?>> var2, WatchEvent.Modifier ... var3);

    abstract void implCancelKey(WatchKey var1);

    abstract void implCloseAll();

    final WatchKey register(Path dir, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (dir == null) {
            throw new NullPointerException();
        }
        HashSet eventSet = new HashSet(events.length);
        for (WatchEvent.Kind<?> event : events) {
            if (event == StandardWatchEventKinds.ENTRY_CREATE || event == StandardWatchEventKinds.ENTRY_MODIFY || event == StandardWatchEventKinds.ENTRY_DELETE) {
                eventSet.add(event);
                continue;
            }
            if (event == StandardWatchEventKinds.OVERFLOW) continue;
            if (event == null) {
                throw new NullPointerException("An element in event set is 'null'");
            }
            throw new UnsupportedOperationException(event.name());
        }
        if (eventSet.isEmpty()) {
            throw new IllegalArgumentException("No events to register");
        }
        return (WatchKey)this.invoke(RequestType.REGISTER, dir, eventSet, modifiers);
    }

    final void cancel(WatchKey key) {
        try {
            this.invoke(RequestType.CANCEL, key);
        }
        catch (IOException x) {
            throw new AssertionError((Object)x.getMessage());
        }
    }

    final void close() throws IOException {
        this.invoke(RequestType.CLOSE, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(RequestType type, Object ... params) throws IOException {
        Request req = new Request(type, params);
        LinkedList<Request> linkedList = this.requestList;
        synchronized (linkedList) {
            if (this.shutdown) {
                throw new ClosedWatchServiceException();
            }
            this.requestList.add(req);
            this.wakeup();
        }
        Object result = req.awaitResult();
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRequests() {
        LinkedList<Request> linkedList = this.requestList;
        synchronized (linkedList) {
            Request req;
            block8: while ((req = this.requestList.poll()) != null) {
                if (this.shutdown) {
                    req.release(new ClosedWatchServiceException());
                    continue;
                }
                switch (req.type()) {
                    case REGISTER: {
                        Object[] params = req.parameters();
                        Path path = (Path)params[0];
                        Set events = (Set)params[1];
                        WatchEvent.Modifier[] modifiers = (WatchEvent.Modifier[])params[2];
                        req.release(this.implRegister(path, events, modifiers));
                        continue block8;
                    }
                    case CANCEL: {
                        Object[] params = req.parameters();
                        WatchKey key = (WatchKey)params[0];
                        this.implCancelKey(key);
                        req.release(null);
                        continue block8;
                    }
                    case CLOSE: {
                        this.implCloseAll();
                        req.release(null);
                        this.shutdown = true;
                        continue block8;
                    }
                }
                req.release(new IOException("request not recognized"));
            }
        }
        return this.shutdown;
    }

    private static class Request {
        private final RequestType type;
        private final Object[] params;
        private boolean completed = false;
        private Object result = null;

        Request(RequestType type, Object ... params) {
            this.type = type;
            this.params = params;
        }

        RequestType type() {
            return this.type;
        }

        Object[] parameters() {
            return this.params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Object result) {
            Request request = this;
            synchronized (request) {
                this.completed = true;
                this.result = result;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object awaitResult() {
            boolean interrupted = false;
            Request request = this;
            synchronized (request) {
                while (!this.completed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException x) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return this.result;
            }
        }
    }

    private static enum RequestType {
        REGISTER,
        CANCEL,
        CLOSE;

    }
}

