/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.StringUTF16;
import sun.nio.cs.Surrogate;

public class SingleByte {
    private static final CoderResult withResult(CoderResult cr, Buffer src, int sp, Buffer dst, int dp) {
        src.position(sp - src.arrayOffset());
        dst.position(dp - dst.arrayOffset());
        return cr;
    }

    public static void initC2B(char[] b2c, char[] c2bNR, char[] c2b, char[] c2bIndex) {
        int i;
        int i2;
        for (i2 = 0; i2 < c2bIndex.length; ++i2) {
            c2bIndex[i2] = 65533;
        }
        for (i2 = 0; i2 < c2b.length; ++i2) {
            c2b[i2] = 65533;
        }
        int off = 0;
        for (i = 0; i < b2c.length; ++i) {
            char c = b2c[i];
            if (c == '\ufffd') continue;
            int index = c >> 8;
            if (c2bIndex[index] == '\ufffd') {
                c2bIndex[index] = (char)off;
                off += 256;
            }
            index = c2bIndex[index] + (c & 0xFF);
            c2b[index] = (char)(i >= 128 ? i - 128 : i + 128);
        }
        if (c2bNR != null) {
            i = 0;
            while (i < c2bNR.length) {
                char c;
                int index;
                char b = c2bNR[i++];
                if (c2bIndex[index = (c = c2bNR[i++]) >> 8] == '\ufffd') {
                    c2bIndex[index] = (char)off;
                    off += 256;
                }
                index = c2bIndex[index] + (c & 0xFF);
                c2b[index] = b;
            }
        }
    }

    public static final class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private Surrogate.Parser sgp;
        private final char[] c2b;
        private final char[] c2bIndex;
        private final boolean isASCIICompatible;
        private byte repl = (byte)63;

        public Encoder(Charset cs, char[] c2b, char[] c2bIndex, boolean isASCIICompatible) {
            super(cs, 1.0f, 1.0f);
            this.c2b = c2b;
            this.c2bIndex = c2bIndex;
            this.isASCIICompatible = isASCIICompatible;
        }

        @Override
        public boolean canEncode(char c) {
            return this.encode(c) != 65533;
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return repl.length == 1 && repl[0] == 63 || super.isLegalReplacement(repl);
        }

        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int len = Math.min(dl - dp, sl - sp);
            while (len-- > 0) {
                char c = sa[sp];
                int b = this.encode(c);
                if (b == 65533) {
                    if (Character.isSurrogate(c)) {
                        if (this.sgp == null) {
                            this.sgp = new Surrogate.Parser();
                        }
                        if (this.sgp.parse(c, sa, sp, sl) < 0) {
                            return SingleByte.withResult(this.sgp.error(), src, sp, dst, dp);
                        }
                        return SingleByte.withResult(this.sgp.unmappableResult(), src, sp, dst, dp);
                    }
                    return SingleByte.withResult(CoderResult.unmappableForLength(1), src, sp, dst, dp);
                }
                da[dp++] = (byte)b;
                ++sp;
            }
            return SingleByte.withResult(sp < sl ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW, src, sp, dst, dp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    int b = this.encode(c);
                    if (b == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp == null) {
                                this.sgp = new Surrogate.Parser();
                            }
                            if (this.sgp.parse(c, src) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (!dst.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put((byte)b);
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        public final int encode(char ch) {
            char index = this.c2bIndex[ch >> 8];
            if (index == '\ufffd') {
                return 65533;
            }
            return this.c2b[index + (ch & 0xFF)];
        }

        @Override
        protected void implReplaceWith(byte[] newReplacement) {
            this.repl = newReplacement[0];
        }

        @Override
        public int encode(char[] src, int sp, int len, byte[] dst) {
            int dp = 0;
            int sl = sp + Math.min(len, dst.length);
            while (sp < sl) {
                char c;
                int b;
                if ((b = this.encode(c = src[sp++])) != 65533) {
                    dst[dp++] = (byte)b;
                    continue;
                }
                if (Character.isHighSurrogate(c) && sp < sl && Character.isLowSurrogate(src[sp])) {
                    if (len > dst.length) {
                        ++sl;
                        --len;
                    }
                    ++sp;
                }
                dst[dp++] = this.repl;
            }
            return dp;
        }

        @Override
        public int encodeFromLatin1(byte[] src, int sp, int len, byte[] dst) {
            int dp = 0;
            int sl = sp + Math.min(len, dst.length);
            while (sp < sl) {
                char c;
                int b;
                if ((b = this.encode(c = (char)(src[sp++] & 0xFF))) == 65533) {
                    dst[dp++] = this.repl;
                    continue;
                }
                dst[dp++] = (byte)b;
            }
            return dp;
        }

        @Override
        public int encodeFromUTF16(byte[] src, int sp, int len, byte[] dst) {
            int dp = 0;
            int sl = sp + Math.min(len, dst.length);
            while (sp < sl) {
                char c;
                int b;
                if ((b = this.encode(c = StringUTF16.getChar(src, sp++))) != 65533) {
                    dst[dp++] = (byte)b;
                    continue;
                }
                if (Character.isHighSurrogate(c) && sp < sl && Character.isLowSurrogate(StringUTF16.getChar(src, sp))) {
                    if (len > dst.length) {
                        ++sl;
                        --len;
                    }
                    ++sp;
                }
                dst[dp++] = this.repl;
            }
            return dp;
        }

        @Override
        public boolean isASCIICompatible() {
            return this.isASCIICompatible;
        }
    }

    public static final class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private final char[] b2c;
        private final boolean isASCIICompatible;
        private char repl = (char)65533;

        public Decoder(Charset cs, char[] b2c) {
            super(cs, 1.0f, 1.0f);
            this.b2c = b2c;
            this.isASCIICompatible = false;
        }

        public Decoder(Charset cs, char[] b2c, boolean isASCIICompatible) {
            super(cs, 1.0f, 1.0f);
            this.b2c = b2c;
            this.isASCIICompatible = isASCIICompatible;
        }

        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            CoderResult cr = CoderResult.UNDERFLOW;
            if (dl - dp < sl - sp) {
                sl = sp + (dl - dp);
                cr = CoderResult.OVERFLOW;
            }
            while (sp < sl) {
                char c = this.decode(sa[sp]);
                if (c == '\ufffd') {
                    return SingleByte.withResult(CoderResult.unmappableForLength(1), src, sp, dst, dp);
                }
                da[dp++] = c;
                ++sp;
            }
            return SingleByte.withResult(cr, src, sp, dst, dp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = this.decode(src.get());
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (!dst.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put(c);
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        public final char decode(int b) {
            return this.b2c[b + 128];
        }

        @Override
        protected void implReplaceWith(String newReplacement) {
            this.repl = newReplacement.charAt(0);
        }

        @Override
        public int decode(byte[] src, int sp, int len, char[] dst) {
            int dp;
            if (len > dst.length) {
                len = dst.length;
            }
            for (dp = 0; dp < len; ++dp) {
                dst[dp] = this.decode(src[sp++]);
                if (dst[dp] != '\ufffd') continue;
                dst[dp] = this.repl;
            }
            return dp;
        }

        @Override
        public boolean isASCIICompatible() {
            return this.isASCIICompatible;
        }
    }
}

