/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.nio.cs.EUC_TWMapping;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;

public class EUC_TW
extends Charset
implements HistoricallyNamedCharset {
    private static final int SS2 = 142;

    public EUC_TW() {
        super("x-EUC-TW", StandardCharsets.aliases_EUC_TW());
    }

    @Override
    public String historicalName() {
        return "EUC_TW";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof EUC_TW;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    public static class Encoder
    extends CharsetEncoder {
        private byte[] bb = new byte[4];
        static final char[] c2b;
        static final char[] c2bIndex;
        static final char[] c2bSupp;
        static final char[] c2bSuppIndex;
        static final byte[] c2bPlane;

        public Encoder(Charset cs) {
            super(cs, 4.0f, 4.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u007f' || this.toEUC(c, this.bb) != -1;
        }

        @Override
        public boolean canEncode(CharSequence cs) {
            int i = 0;
            while (i < cs.length()) {
                char c;
                if (Character.isHighSurrogate(c = cs.charAt(i++))) {
                    char low;
                    if (i == cs.length()) {
                        return false;
                    }
                    if (Character.isLowSurrogate(low = cs.charAt(i++)) && this.toEUC(c, low, this.bb) != -1) continue;
                    return false;
                }
                if (this.canEncode(c)) continue;
                return false;
            }
            return true;
        }

        public int toEUC(char hi, char low, byte[] bb) {
            return Encoder.encode(hi, low, bb);
        }

        public int toEUC(char c, byte[] bb) {
            return Encoder.encode(c, bb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl; sp += inSize) {
                    int outSize;
                    char c = sa[sp];
                    inSize = 1;
                    if (c < '\u0080') {
                        this.bb[0] = (byte)c;
                        outSize = 1;
                    } else {
                        outSize = this.toEUC(c, this.bb);
                        if (outSize == -1) {
                            if (Character.isHighSurrogate(c)) {
                                if (sp + 1 == sl) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                if (!Character.isLowSurrogate(sa[sp + 1])) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                outSize = this.toEUC(c, sa[sp + 1], this.bb);
                                inSize = 2;
                            } else if (Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                        }
                    }
                    if (outSize == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(inSize);
                        return coderResult;
                    }
                    if (dl - dp < outSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < outSize; ++i) {
                        da[dp++] = this.bb[i];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    int outSize;
                    int inSize = 1;
                    char c = src.get();
                    if (c < '\u0080') {
                        outSize = 1;
                        this.bb[0] = (byte)c;
                    } else {
                        outSize = this.toEUC(c, this.bb);
                        if (outSize == -1) {
                            if (Character.isHighSurrogate(c)) {
                                if (!src.hasRemaining()) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                char c2 = src.get();
                                if (!Character.isLowSurrogate(c2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                outSize = this.toEUC(c, c2, this.bb);
                                inSize = 2;
                            } else if (Character.isLowSurrogate(c)) {
                                CoderResult c2 = CoderResult.malformedForLength(1);
                                return c2;
                            }
                        }
                    }
                    if (outSize == -1) {
                        CoderResult c2 = CoderResult.unmappableForLength(inSize);
                        return c2;
                    }
                    if (dst.remaining() < outSize) {
                        CoderResult c2 = CoderResult.OVERFLOW;
                        return c2;
                    }
                    for (int i = 0; i < outSize; ++i) {
                        dst.put(this.bb[i]);
                    }
                    mark += inSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        static int encode(char hi, char low, byte[] bb) {
            int c = Character.toCodePoint(hi, low);
            if ((c & 0xF0000) != 131072) {
                return -1;
            }
            int index = c2bSuppIndex[(c -= 131072) >> 8];
            if (index == 65533) {
                return -1;
            }
            char db = c2bSupp[index += c & 0xFF];
            if (db == '\ufffd') {
                return -1;
            }
            int p = c2bPlane[index] >> 4 & 0xF;
            bb[0] = -114;
            bb[1] = (byte)(0xA0 | p);
            bb[2] = (byte)(db >> 8);
            bb[3] = (byte)db;
            return 4;
        }

        static int encode(char c, byte[] bb) {
            int index = c2bIndex[c >> 8];
            if (index == 65533) {
                return -1;
            }
            char db = c2b[index += c & 0xFF];
            if (db == '\ufffd') {
                return -1;
            }
            int p = c2bPlane[index] & 0xF;
            if (p == 0) {
                bb[0] = (byte)(db >> 8);
                bb[1] = (byte)db;
                return 2;
            }
            bb[0] = -114;
            bb[1] = (byte)(0xA0 | p);
            bb[2] = (byte)(db >> 8);
            bb[3] = (byte)db;
            return 4;
        }

        static {
            int b1Min = 161;
            int b1Max = 254;
            int b2Min = 161;
            int b2Max = 254;
            int dbSegSize = 94;
            String[] b2c = Decoder.b2c;
            byte[] b2cIsSupp = Decoder.b2cIsSupp;
            c2bIndex = EUC_TWMapping.c2bIndex;
            c2bSuppIndex = EUC_TWMapping.c2bSuppIndex;
            char[] c2b0 = new char[31744];
            char[] c2bSupp0 = new char[43520];
            byte[] c2bPlane0 = new byte[Math.max(31744, 43520)];
            Arrays.fill(c2b0, '\ufffd');
            Arrays.fill(c2bSupp0, '\ufffd');
            for (int p = 0; p < b2c.length; ++p) {
                String db = b2c[p];
                int plane = p;
                if (plane == 7) {
                    plane = 15;
                } else if (plane != 0) {
                    plane = p + 1;
                }
                int off = 0;
                for (int b1 = b1Min; b1 <= b1Max; ++b1) {
                    for (int b2 = b2Min; b2 <= b2Max; ++b2) {
                        char c = db.charAt(off);
                        if (c != '\ufffd') {
                            int index;
                            if ((b2cIsSupp[off] & 1 << p) != 0) {
                                index = c2bSuppIndex[c >> 8] + (c & 0xFF);
                                c2bSupp0[index] = (char)((b1 << 8) + b2);
                                int n = index;
                                c2bPlane0[n] = (byte)(c2bPlane0[n] | (byte)(plane << 4));
                            } else {
                                index = c2bIndex[c >> 8] + (c & 0xFF);
                                c2b0[index] = (char)((b1 << 8) + b2);
                                int n = index;
                                c2bPlane0[n] = (byte)(c2bPlane0[n] | (byte)plane);
                            }
                        }
                        ++off;
                    }
                }
            }
            c2b = c2b0;
            c2bSupp = c2bSupp0;
            c2bPlane = c2bPlane0;
        }
    }

    public static class Decoder
    extends CharsetDecoder {
        char[] c1 = new char[1];
        char[] c2 = new char[2];
        static final String[] b2c = EUC_TWMapping.b2c;
        static final int b1Min = 161;
        static final int b1Max = 254;
        static final int b2Min = 161;
        static final int b2Max = 254;
        static final int dbSegSize = 94;
        static final byte[] b2cIsSupp;
        static final byte[] cnspToIndex;

        public Decoder(Charset cs) {
            super(cs, 2.0f, 2.0f);
        }

        public char[] toUnicode(int b1, int b2, int p) {
            return Decoder.decode(b1, b2, p, this.c1, this.c2);
        }

        static boolean isLegalDB(int b) {
            return b >= 161 && b <= 254;
        }

        static char[] decode(int b1, int b2, int p, char[] c1, char[] c2) {
            if (b1 < 161 || b1 > 254 || b2 < 161 || b2 > 254) {
                return null;
            }
            int index = (b1 - 161) * 94 + b2 - 161;
            char c = b2c[p].charAt(index);
            if (c == '\ufffd') {
                return null;
            }
            if ((b2cIsSupp[index] & 1 << p) == 0) {
                c1[0] = c;
                return c1;
            }
            c2[0] = Character.highSurrogate(131072 + c);
            c2[1] = Character.lowSurrogate(131072 + c);
            return c2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                while (sp < sl) {
                    CoderResult coderResult;
                    int byte1 = sa[sp] & 0xFF;
                    if (byte1 == 142) {
                        if (sl - sp < 4) {
                            CoderResult coderResult2 = CoderResult.UNDERFLOW;
                            return coderResult2;
                        }
                        byte cnsPlane = cnspToIndex[sa[sp + 1] & 0xFF];
                        if (cnsPlane < 0) {
                            CoderResult coderResult3 = CoderResult.malformedForLength(2);
                            return coderResult3;
                        }
                        byte1 = sa[sp + 2] & 0xFF;
                        int byte2 = sa[sp + 3] & 0xFF;
                        char[] cc = this.toUnicode(byte1, byte2, cnsPlane);
                        if (cc == null) {
                            if (!Decoder.isLegalDB(byte1) || !Decoder.isLegalDB(byte2)) {
                                CoderResult coderResult4 = CoderResult.malformedForLength(4);
                                return coderResult4;
                            }
                            CoderResult coderResult5 = CoderResult.unmappableForLength(4);
                            return coderResult5;
                        }
                        if (dl - dp < cc.length) {
                            CoderResult coderResult6 = CoderResult.OVERFLOW;
                            return coderResult6;
                        }
                        if (cc.length == 1) {
                            da[dp++] = cc[0];
                        } else {
                            da[dp++] = cc[0];
                            da[dp++] = cc[1];
                        }
                        sp += 4;
                        continue;
                    }
                    if (byte1 < 128) {
                        if (dl - dp < 1) {
                            CoderResult cnsPlane = CoderResult.OVERFLOW;
                            return cnsPlane;
                        }
                        da[dp++] = (char)byte1;
                        ++sp;
                        continue;
                    }
                    if (sl - sp < 2) {
                        CoderResult cnsPlane = CoderResult.UNDERFLOW;
                        return cnsPlane;
                    }
                    int byte2 = sa[sp + 1] & 0xFF;
                    char[] cc = this.toUnicode(byte1, byte2, 0);
                    if (cc == null) {
                        if (!Decoder.isLegalDB(byte1) || !Decoder.isLegalDB(byte2)) {
                            coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    if (dl - dp < 1) {
                        coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = cc[0];
                    sp += 2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    CoderResult coderResult;
                    int byte1 = src.get() & 0xFF;
                    if (byte1 == 142) {
                        int byte2;
                        if (src.remaining() < 3) {
                            CoderResult coderResult2 = CoderResult.UNDERFLOW;
                            return coderResult2;
                        }
                        byte cnsPlane = cnspToIndex[src.get() & 0xFF];
                        if (cnsPlane < 0) {
                            CoderResult coderResult3 = CoderResult.malformedForLength(2);
                            return coderResult3;
                        }
                        byte1 = src.get() & 0xFF;
                        char[] cc = this.toUnicode(byte1, byte2 = src.get() & 0xFF, cnsPlane);
                        if (cc == null) {
                            if (!Decoder.isLegalDB(byte1) || !Decoder.isLegalDB(byte2)) {
                                CoderResult coderResult4 = CoderResult.malformedForLength(4);
                                return coderResult4;
                            }
                            CoderResult coderResult5 = CoderResult.unmappableForLength(4);
                            return coderResult5;
                        }
                        if (dst.remaining() < cc.length) {
                            CoderResult coderResult6 = CoderResult.OVERFLOW;
                            return coderResult6;
                        }
                        if (cc.length == 1) {
                            dst.put(cc[0]);
                        } else {
                            dst.put(cc[0]);
                            dst.put(cc[1]);
                        }
                        mark += 4;
                        continue;
                    }
                    if (byte1 < 128) {
                        if (!dst.hasRemaining()) {
                            CoderResult cnsPlane = CoderResult.OVERFLOW;
                            return cnsPlane;
                        }
                        dst.put((char)byte1);
                        ++mark;
                        continue;
                    }
                    if (!src.hasRemaining()) {
                        CoderResult cnsPlane = CoderResult.UNDERFLOW;
                        return cnsPlane;
                    }
                    int byte2 = src.get() & 0xFF;
                    char[] cc = this.toUnicode(byte1, byte2, 0);
                    if (cc == null) {
                        if (!Decoder.isLegalDB(byte1) || !Decoder.isLegalDB(byte2)) {
                            coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    if (!dst.hasRemaining()) {
                        coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put(cc[0]);
                    mark += 2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        static {
            cnspToIndex = new byte[256];
            Arrays.fill(cnspToIndex, (byte)-1);
            Decoder.cnspToIndex[162] = 1;
            Decoder.cnspToIndex[163] = 2;
            Decoder.cnspToIndex[164] = 3;
            Decoder.cnspToIndex[165] = 4;
            Decoder.cnspToIndex[166] = 5;
            Decoder.cnspToIndex[167] = 6;
            Decoder.cnspToIndex[175] = 7;
            String b2cIsSuppStr = EUC_TWMapping.b2cIsSuppStr;
            byte[] flag = new byte[b2cIsSuppStr.length() << 1];
            int off = 0;
            for (int i = 0; i < b2cIsSuppStr.length(); ++i) {
                char c = b2cIsSuppStr.charAt(i);
                flag[off++] = (byte)(c >> 8);
                flag[off++] = (byte)(c & 0xFF);
            }
            b2cIsSupp = flag;
        }
    }
}

