/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import sun.net.ResourceManager;
import sun.net.ext.ExtendedSocketOptions;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.MembershipKeyImpl;
import sun.nio.ch.MembershipRegistry;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd = new DatagramDispatcher();
    private final ProtocolFamily family;
    private final FileDescriptor fd;
    private final int fdVal;
    private InetAddress cachedSenderInetAddress;
    private int cachedSenderPort;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Object stateLock = new Object();
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_CONNECTED = 1;
    private static final int ST_CLOSING = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state;
    private long readerThread;
    private long writerThread;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private DatagramSocket socket;
    private MembershipRegistry registry;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;
    private SocketAddress sender;

    public DatagramChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        ResourceManager.beforeUdpCreate();
        try {
            this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
            this.fd = Net.socket(this.family, false);
            this.fdVal = IOUtil.fdVal(this.fd);
        }
        catch (IOException ioe) {
            ResourceManager.afterUdpClose();
            throw ioe;
        }
    }

    public DatagramChannelImpl(SelectorProvider sp, ProtocolFamily family) throws IOException {
        super(sp);
        Objects.requireNonNull(family, "'family' is null");
        if (family != StandardProtocolFamily.INET && family != StandardProtocolFamily.INET6) {
            throw new UnsupportedOperationException("Protocol family not supported");
        }
        if (family == StandardProtocolFamily.INET6 && !Net.isIPv6Available()) {
            throw new UnsupportedOperationException("IPv6 not available");
        }
        ResourceManager.beforeUdpCreate();
        try {
            this.family = family;
            this.fd = Net.socket(family, false);
            this.fdVal = IOUtil.fdVal(this.fd);
        }
        catch (IOException ioe) {
            ResourceManager.afterUdpClose();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannelImpl(SelectorProvider sp, FileDescriptor fd) throws IOException {
        super(sp);
        ResourceManager.beforeUdpCreate();
        this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        Object object = this.stateLock;
        synchronized (object) {
            this.localAddress = Net.localAddress(fd);
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> DatagramChannel setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (name == StandardSocketOptions.IP_TOS || name == StandardSocketOptions.IP_MULTICAST_TTL || name == StandardSocketOptions.IP_MULTICAST_LOOP) {
                Net.setSocketOption(this.fd, this.family, name, value);
                return this;
            }
            if (name == StandardSocketOptions.IP_MULTICAST_IF) {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot set IP_MULTICAST_IF to 'null'");
                }
                NetworkInterface interf = (NetworkInterface)value;
                if (this.family == StandardProtocolFamily.INET6) {
                    int index = interf.getIndex();
                    if (index == -1) {
                        throw new IOException("Network interface cannot be identified");
                    }
                    Net.setInterface6(this.fd, index);
                } else {
                    Inet4Address target = Net.anyInet4Address(interf);
                    if (target == null) {
                        throw new IOException("Network interface not configured for IPv4");
                    }
                    int targetAddress = Net.inet4AsInt(target);
                    Net.setInterface4(this.fd, targetAddress);
                }
                return this;
            }
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind() && this.localAddress != null) {
                this.reuseAddressEmulated = true;
                this.isReuseAddress = (Boolean)value;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (name == StandardSocketOptions.IP_TOS || name == StandardSocketOptions.IP_MULTICAST_TTL || name == StandardSocketOptions.IP_MULTICAST_LOOP) {
                return (T)Net.getSocketOption(this.fd, this.family, name);
            }
            if (name == StandardSocketOptions.IP_MULTICAST_IF) {
                if (this.family == StandardProtocolFamily.INET) {
                    int address = Net.getInterface4(this.fd);
                    if (address == 0) {
                        return null;
                    }
                    InetAddress ia = Net.inet4FromInt(address);
                    NetworkInterface ni = NetworkInterface.getByInetAddress(ia);
                    if (ni == null) {
                        throw new IOException("Unable to map address to interface");
                    }
                    return (T)ni;
                }
                int index = Net.getInterface6(this.fd);
                if (index == 0) {
                    return null;
                }
                NetworkInterface ni = NetworkInterface.getByIndex(index);
                if (ni == null) {
                    throw new IOException("Unable to map index to interface");
                }
                return (T)ni;
            }
            if (name == StandardSocketOptions.SO_REUSEADDR && this.reuseAddressEmulated) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, name);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress beginRead(boolean blocking, boolean mustBeConnected) throws IOException {
        InetSocketAddress remote;
        if (blocking) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            remote = this.remoteAddress;
            if (remote == null && mustBeConnected) {
                throw new NotYetConnectedException();
            }
            if (this.localAddress == null) {
                this.bindInternal(null);
            }
            if (blocking) {
                this.readerThread = NativeThread.current();
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRead(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object = this.stateLock;
            synchronized (object) {
                this.readerThread = 0L;
                if (this.state == 2) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(completed);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SocketAddress receive(ByteBuffer dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(FileDescriptor fd, ByteBuffer dst, boolean connected) throws IOException {
        int rem;
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer && rem > 0) {
            return this.receiveIntoNativeBuffer(fd, dst, rem, pos, connected);
        }
        int newSize = Math.max(rem, 1);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(newSize);
        try {
            int n2 = this.receiveIntoNativeBuffer(fd, bb, newSize, 0, connected);
            bb.flip();
            if (n2 > 0 && rem > 0) {
                dst.put(bb);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int receiveIntoNativeBuffer(FileDescriptor fd, ByteBuffer bb, int rem, int pos, boolean connected) throws IOException {
        int n = this.receive0(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, connected);
        if (n > 0) {
            bb.position(pos + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        Objects.requireNonNull(src);
        InetSocketAddress isa = Net.checkAddress(target, this.family);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                SocketAddress remote = this.beginWrite(blocking, false);
                if (remote != null) {
                    if (!target.equals(remote)) {
                        throw new AlreadyConnectedException();
                    }
                    while ((n = IOUtil.write(this.fd, src, -1L, nd)) == -3 && this.isOpen()) {
                    }
                } else {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        InetAddress ia = isa.getAddress();
                        if (ia.isMulticastAddress()) {
                            sm.checkMulticast(ia);
                        } else {
                            sm.checkConnect(ia.getHostAddress(), isa.getPort());
                        }
                    }
                    while ((n = this.send(this.fd, src, isa)) == -3 && this.isOpen()) {
                    }
                }
                this.endWrite(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(FileDescriptor fd, ByteBuffer src, InetSocketAddress target) throws IOException {
        if (src instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fd, src, target);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer bb = Util.getTemporaryDirectBuffer(rem);
        try {
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n = this.sendFromNativeBuffer(fd, bb, target);
            if (n > 0) {
                src.position(pos + n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int sendFromNativeBuffer(FileDescriptor fd, ByteBuffer bb, InetSocketAddress target) throws IOException {
        int written;
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        boolean preferIPv6 = this.family != StandardProtocolFamily.INET;
        try {
            written = this.send0(preferIPv6, fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, target.getAddress(), target.getPort());
        }
        catch (PortUnreachableException pue) {
            if (this.isConnected()) {
                throw pue;
            }
            written = rem;
        }
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer buf) throws IOException {
        Objects.requireNonNull(buf);
        this.readLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginRead(blocking, true);
                while ((n = IOUtil.read(this.fd, buf, -1L, nd)) == -3 && this.isOpen()) {
                }
                this.endRead(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dsts.length);
        this.readLock.lock();
        try {
            boolean blocking = this.isBlocking();
            long n = 0L;
            try {
                this.beginRead(blocking, true);
                while ((n = IOUtil.read(this.fd, dsts, offset, length, nd)) == -3L && this.isOpen()) {
                }
                this.endRead(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                this.endRead(blocking, n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            long l = IOStatus.normalize(n);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress beginWrite(boolean blocking, boolean mustBeConnected) throws IOException {
        InetSocketAddress remote;
        if (blocking) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            remote = this.remoteAddress;
            if (remote == null && mustBeConnected) {
                throw new NotYetConnectedException();
            }
            if (this.localAddress == null) {
                this.bindInternal(null);
            }
            if (blocking) {
                this.writerThread = NativeThread.current();
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWrite(boolean blocking, boolean completed) throws AsynchronousCloseException {
        if (blocking) {
            Object object = this.stateLock;
            synchronized (object) {
                this.writerThread = 0L;
                if (this.state == 2) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buf) throws IOException {
        Objects.requireNonNull(buf);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            int n = 0;
            try {
                this.beginWrite(blocking, true);
                while ((n = IOUtil.write(this.fd, buf, -1L, nd)) == -3 && this.isOpen()) {
                }
                this.endWrite(blocking, n > 0);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            int n2 = IOStatus.normalize(n);
            return n2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, srcs.length);
        this.writeLock.lock();
        try {
            boolean blocking = this.isBlocking();
            long n = 0L;
            try {
                this.beginWrite(blocking, true);
                while ((n = IOUtil.write(this.fd, srcs, offset, length, nd)) == -3L && this.isOpen()) {
                }
                this.endWrite(blocking, n > 0L);
            }
            catch (Throwable throwable) {
                this.endWrite(blocking, n > 0L);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            long l = IOStatus.normalize(n);
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                    IOUtil.configureBlocking(this.fd, block);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel bind(SocketAddress local) throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    this.bindInternal(local);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    private void bindInternal(SocketAddress local) throws IOException {
        assert (Thread.holdsLock(this.stateLock) && this.localAddress == null);
        InetSocketAddress isa = local == null ? (this.family == StandardProtocolFamily.INET ? new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0) : new InetSocketAddress(0)) : Net.checkAddress(local, this.family);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkListen(isa.getPort());
        }
        Net.bind(this.family, this.fd, isa.getAddress(), isa.getPort());
        this.localAddress = Net.localAddress(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel connect(SocketAddress sa) throws IOException {
        InetSocketAddress isa = Net.checkAddress(sa, this.family);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            InetAddress ia = isa.getAddress();
            if (ia.isMulticastAddress()) {
                sm.checkMulticast(ia);
            } else {
                sm.checkConnect(ia.getHostAddress(), isa.getPort());
                sm.checkAccept(ia.getHostAddress(), isa.getPort());
            }
        }
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    this.ensureOpen();
                    if (this.state == 1) {
                        throw new AlreadyConnectedException();
                    }
                    int n = Net.connect(this.family, this.fd, isa.getAddress(), isa.getPort());
                    if (n <= 0) {
                        throw new Error();
                    }
                    this.remoteAddress = isa;
                    this.state = 1;
                    this.localAddress = Net.localAddress(this.fd);
                    boolean blocking = this.isBlocking();
                    if (blocking) {
                        IOUtil.configureBlocking(this.fd, false);
                    }
                    try {
                        ByteBuffer buf = ByteBuffer.allocate(100);
                        while (this.receive(buf) != null) {
                            buf.clear();
                        }
                    }
                    finally {
                        if (blocking) {
                            IOUtil.configureBlocking(this.fd, true);
                        }
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel disconnect() throws IOException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    block12: {
                        if (this.isOpen() && this.state == 1) break block12;
                        DatagramChannelImpl datagramChannelImpl = this;
                        return datagramChannelImpl;
                    }
                    boolean isIPv6 = this.family == StandardProtocolFamily.INET6;
                    DatagramChannelImpl.disconnect0(this.fd, isIPv6);
                    this.remoteAddress = null;
                    this.state = 0;
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MembershipKey innerJoin(InetAddress group, NetworkInterface interf, InetAddress source) throws IOException {
        SecurityManager sm;
        if (!group.isMulticastAddress()) {
            throw new IllegalArgumentException("Group not a multicast address");
        }
        if (group instanceof Inet4Address) {
            if (this.family == StandardProtocolFamily.INET6 && !Net.canIPv6SocketJoinIPv4Group()) {
                throw new IllegalArgumentException("IPv6 socket cannot join IPv4 multicast group");
            }
        } else if (group instanceof Inet6Address) {
            if (this.family != StandardProtocolFamily.INET6) {
                throw new IllegalArgumentException("Only IPv6 sockets can join IPv6 multicast group");
            }
        } else {
            throw new IllegalArgumentException("Address type not supported");
        }
        if (source != null) {
            if (source.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (source.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (source.getClass() != group.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkMulticast(group);
        }
        Object object = this.stateLock;
        synchronized (object) {
            MembershipKey key;
            this.ensureOpen();
            if (this.registry == null) {
                this.registry = new MembershipRegistry();
            } else {
                key = this.registry.checkMembership(group, interf, source);
                if (key != null) {
                    return key;
                }
            }
            if (this.family == StandardProtocolFamily.INET6 && (group instanceof Inet6Address || Net.canJoin6WithIPv4Group())) {
                byte[] sourceAddress;
                int index = interf.getIndex();
                if (index == -1) {
                    throw new IOException("Network interface cannot be identified");
                }
                byte[] groupAddress = Net.inet6AsByteArray(group);
                int n = Net.join6(this.fd, groupAddress, index, sourceAddress = source == null ? null : Net.inet6AsByteArray(source));
                if (n == -2) {
                    throw new UnsupportedOperationException();
                }
                key = new MembershipKeyImpl.Type6(this, group, interf, source, groupAddress, index, sourceAddress);
            } else {
                int sourceAddress;
                int targetAddress;
                Inet4Address target = Net.anyInet4Address(interf);
                if (target == null) {
                    throw new IOException("Network interface not configured for IPv4");
                }
                int groupAddress = Net.inet4AsInt(group);
                int n = Net.join4(this.fd, groupAddress, targetAddress = Net.inet4AsInt(target), sourceAddress = source == null ? 0 : Net.inet4AsInt(source));
                if (n == -2) {
                    throw new UnsupportedOperationException();
                }
                key = new MembershipKeyImpl.Type4(this, group, interf, source, groupAddress, targetAddress, sourceAddress);
            }
            this.registry.add((MembershipKeyImpl)key);
            return key;
        }
    }

    @Override
    public MembershipKey join(InetAddress group, NetworkInterface interf) throws IOException {
        return this.innerJoin(group, interf, null);
    }

    @Override
    public MembershipKey join(InetAddress group, NetworkInterface interf, InetAddress source) throws IOException {
        Objects.requireNonNull(source);
        return this.innerJoin(group, interf, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drop(MembershipKeyImpl key) {
        assert (key.channel() == this);
        Object object = this.stateLock;
        synchronized (object) {
            if (!key.isValid()) {
                return;
            }
            try {
                if (key instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)key;
                    Net.drop6(this.fd, key6.groupAddress(), key6.index(), key6.source());
                } else {
                    MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)key;
                    Net.drop4(this.fd, key4.groupAddress(), key4.interfaceAddress(), key4.source());
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
            key.invalidate();
            this.registry.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void block(MembershipKeyImpl key, InetAddress source) throws IOException {
        assert (key.channel() == this);
        assert (key.sourceAddress() == null);
        Object object = this.stateLock;
        synchronized (object) {
            int n;
            if (!key.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            if (source.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (source.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (source.getClass() != key.group().getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            if (key instanceof MembershipKeyImpl.Type6) {
                MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)key;
                n = Net.block6(this.fd, key6.groupAddress(), key6.index(), Net.inet6AsByteArray(source));
            } else {
                MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)key;
                n = Net.block4(this.fd, key4.groupAddress(), key4.interfaceAddress(), Net.inet4AsInt(source));
            }
            if (n == -2) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblock(MembershipKeyImpl key, InetAddress source) {
        assert (key.channel() == this);
        assert (key.sourceAddress() == null);
        Object object = this.stateLock;
        synchronized (object) {
            if (!key.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            try {
                if (key instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 key6 = (MembershipKeyImpl.Type6)key;
                    Net.unblock6(this.fd, key6.groupAddress(), key6.index(), Net.inet6AsByteArray(source));
                } else {
                    MembershipKeyImpl.Type4 key4 = (MembershipKeyImpl.Type4)key;
                    Net.unblock4(this.fd, key4.groupAddress(), key4.interfaceAddress(), Net.inet4AsInt(source));
                }
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        boolean blocking;
        assert (!this.isOpen());
        boolean interrupted = false;
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.state < 2);
            blocking = this.isBlocking();
            this.state = 2;
            if (this.registry != null) {
                this.registry.invalidateAll();
            }
        }
        if (blocking) {
            object = this.stateLock;
            synchronized (object) {
                assert (this.state == 2);
                long reader = this.readerThread;
                long writer = this.writerThread;
                if (reader != 0L || writer != 0L) {
                    nd.preClose(this.fd);
                    if (reader != 0L) {
                        NativeThread.signal(reader);
                    }
                    if (writer != 0L) {
                        NativeThread.signal(writer);
                    }
                    while (this.readerThread != 0L || this.writerThread != 0L) {
                        try {
                            this.stateLock.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
            }
        }
        this.readLock.lock();
        try {
            this.writeLock.lock();
            this.writeLock.unlock();
        }
        finally {
            this.readLock.unlock();
        }
        object = this.stateLock;
        synchronized (object) {
            assert (this.state == 2);
            this.state = 3;
        }
        if (!this.isRegistered()) {
            this.kill();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                this.state = 4;
                try {
                    nd.close(this.fd);
                }
                finally {
                    ResourceManager.afterUdpClose();
                }
            }
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl ski) {
        int intOps = ski.nioInterestOps();
        int oldOps = ski.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            ski.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0) {
            newOps |= 1;
        }
        if ((ops & Net.POLLOUT) != 0 && (intOps & 4) != 0) {
            newOps |= 4;
        }
        ski.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, ski.nioReadyOps(), ski);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl ski) {
        return this.translateReadyOps(ops, 0, ski);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollRead(long timeout) throws IOException {
        boolean blocking = this.isBlocking();
        assert (Thread.holdsLock(this.blockingLock()) && blocking);
        this.readLock.lock();
        try {
            boolean polled = false;
            try {
                this.beginRead(blocking, false);
                int events = Net.poll(this.fd, Net.POLLIN, timeout);
                polled = events != 0;
            }
            finally {
                this.endRead(blocking, polled);
            }
            boolean bl = polled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int translateInterestOps(int ops) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= Net.POLLIN;
        }
        if ((ops & 4) != 0) {
            newOps |= Net.POLLOUT;
        }
        if ((ops & 8) != 0) {
            newOps |= Net.POLLIN;
        }
        return newOps;
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0, boolean var1) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    private native int send0(boolean var1, FileDescriptor var2, long var3, int var5, InetAddress var6, int var7) throws IOException;

    static {
        IOUtil.load();
        DatagramChannelImpl.initIDs();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Object>> set = new HashSet<SocketOption<Object>>();
            set.add(StandardSocketOptions.SO_SNDBUF);
            set.add(StandardSocketOptions.SO_RCVBUF);
            set.add(StandardSocketOptions.SO_REUSEADDR);
            if (Net.isReusePortAvailable()) {
                set.add(StandardSocketOptions.SO_REUSEPORT);
            }
            set.add(StandardSocketOptions.SO_BROADCAST);
            set.add(StandardSocketOptions.IP_TOS);
            set.add(StandardSocketOptions.IP_MULTICAST_IF);
            set.add(StandardSocketOptions.IP_MULTICAST_TTL);
            set.add(StandardSocketOptions.IP_MULTICAST_LOOP);
            set.addAll(ExtendedSocketOptions.options((short)2));
            return Collections.unmodifiableSet(set);
        }
    }
}

