/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.CollSer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.KeyValueHolder;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

class ImmutableCollections {
    static final int SALT;
    static final int EXPAND_FACTOR = 2;

    private ImmutableCollections() {
    }

    static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    static <E> List<E> listCopy(Collection<? extends E> coll) {
        if (coll instanceof AbstractImmutableList && coll.getClass() != SubList.class) {
            return (List)coll;
        }
        return List.of(coll.toArray());
    }

    static <E> List<E> emptyList() {
        return ListN.EMPTY_LIST;
    }

    static <E> Set<E> emptySet() {
        return SetN.EMPTY_SET;
    }

    static <K, V> Map<K, V> emptyMap() {
        return MapN.EMPTY_MAP;
    }

    static {
        long nt = System.nanoTime();
        SALT = (int)(nt >>> 32 ^ nt);
    }

    static final class MapN<K, V>
    extends AbstractImmutableMap<K, V> {
        static Map<?, ?> EMPTY_MAP;
        final Object[] table;
        final int size;

        MapN(Object ... input) {
            if ((input.length & 1) != 0) {
                throw new InternalError("length is odd");
            }
            this.size = input.length >> 1;
            int len = 2 * input.length;
            len = len + 1 & 0xFFFFFFFE;
            this.table = new Object[len];
            for (int i = 0; i < input.length; i += 2) {
                Object k = Objects.requireNonNull(input[i]);
                Object v = Objects.requireNonNull(input[i + 1]);
                int idx = this.probe(k);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate key: " + k);
                }
                int dest = -(idx + 1);
                this.table[dest] = k;
                this.table[dest + 1] = v;
            }
        }

        @Override
        public boolean containsKey(Object o) {
            Objects.requireNonNull(o);
            return this.size > 0 && this.probe(o) >= 0;
        }

        @Override
        public boolean containsValue(Object o) {
            Objects.requireNonNull(o);
            for (int i = 1; i < this.table.length; i += 2) {
                Object v = this.table[i];
                if (v == null || !o.equals(v)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.table.length; i += 2) {
                Object k = this.table[i];
                if (k == null) continue;
                hash += k.hashCode() ^ this.table[i + 1].hashCode();
            }
            return hash;
        }

        @Override
        public V get(Object o) {
            if (this.size == 0) {
                Objects.requireNonNull(o);
                return null;
            }
            int i = this.probe(o);
            if (i >= 0) {
                return (V)this.table[i + 1];
            }
            return null;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new MapNIterator();
                }
            };
        }

        private int probe(Object pk) {
            int idx = Math.floorMod(pk.hashCode(), this.table.length >> 1) << 1;
            Object ek;
            while ((ek = this.table[idx]) != null) {
                if (pk.equals(ek)) {
                    return idx;
                }
                if ((idx += 2) != this.table.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[2 * this.size];
            int len = this.table.length;
            int dest = 0;
            for (int i = 0; i < len; i += 2) {
                if (this.table[i] == null) continue;
                array[dest++] = this.table[i];
                array[dest++] = this.table[i + 1];
            }
            return new CollSer(3, array);
        }

        static {
            if (EMPTY_MAP == null) {
                EMPTY_MAP = new MapN(new Object[0]);
            }
        }

        class MapNIterator
        implements Iterator<Map.Entry<K, V>> {
            private int remaining;
            private int idx;

            MapNIterator() {
                this.remaining = MapN.this.size();
                if (this.remaining > 0) {
                    this.idx = Math.floorMod(SALT, MapN.this.table.length >> 1) << 1;
                }
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            private int nextIndex() {
                int idx = this.idx;
                if (SALT >= 0) {
                    if ((idx += 2) >= MapN.this.table.length) {
                        idx = 0;
                    }
                } else if ((idx -= 2) < 0) {
                    idx = MapN.this.table.length - 2;
                }
                this.idx = idx;
                return this.idx;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hasNext()) {
                    while (MapN.this.table[this.nextIndex()] == null) {
                    }
                    KeyValueHolder<Object, Object> e = new KeyValueHolder<Object, Object>(MapN.this.table[this.idx], MapN.this.table[this.idx + 1]);
                    --this.remaining;
                    return e;
                }
                throw new NoSuchElementException();
            }
        }
    }

    static final class Map1<K, V>
    extends AbstractImmutableMap<K, V> {
        private final K k0;
        private final V v0;

        Map1(K k0, V v0) {
            this.k0 = Objects.requireNonNull(k0);
            this.v0 = Objects.requireNonNull(v0);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Set.of(new KeyValueHolder<K, V>(this.k0, this.v0));
        }

        @Override
        public V get(Object o) {
            return o.equals(this.k0) ? (V)this.v0 : null;
        }

        @Override
        public boolean containsKey(Object o) {
            return o.equals(this.k0);
        }

        @Override
        public boolean containsValue(Object o) {
            return o.equals(this.v0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(3, this.k0, this.v0);
        }

        @Override
        public int hashCode() {
            return this.k0.hashCode() ^ this.v0.hashCode();
        }
    }

    static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        AbstractImmutableMap() {
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V put(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V remove(Object key) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V replace(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> f) {
            throw ImmutableCollections.uoe();
        }
    }

    static final class SetN<E>
    extends AbstractImmutableSet<E>
    implements Serializable {
        static Set<?> EMPTY_SET;
        final E[] elements;
        final int size;

        @SafeVarargs
        SetN(E ... input) {
            this.size = input.length;
            this.elements = new Object[2 * input.length];
            for (int i = 0; i < input.length; ++i) {
                E e = input[i];
                int idx = this.probe(e);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate element: " + e);
                }
                this.elements[-(idx + 1)] = e;
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o);
            return this.size > 0 && this.probe(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new SetNIterator();
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (E e : this.elements) {
                if (e == null) continue;
                h += e.hashCode();
            }
            return h;
        }

        private int probe(Object pe) {
            int idx = Math.floorMod(pe.hashCode(), this.elements.length);
            E ee;
            while ((ee = this.elements[idx]) != null) {
                if (pe.equals(ee)) {
                    return idx;
                }
                if (++idx != this.elements.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[this.size];
            int dest = 0;
            for (E o : this.elements) {
                if (o == null) continue;
                array[dest++] = o;
            }
            return new CollSer(2, array);
        }

        static {
            if (EMPTY_SET == null) {
                EMPTY_SET = new SetN<Object>(new Object[0]);
            }
        }

        private final class SetNIterator
        implements Iterator<E> {
            private int remaining;
            private int idx;

            SetNIterator() {
                this.remaining = SetN.this.size();
                if (this.remaining > 0) {
                    this.idx = Math.floorMod(SALT, SetN.this.elements.length);
                }
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            private int nextIndex() {
                int idx = this.idx;
                if (SALT >= 0) {
                    if (++idx >= SetN.this.elements.length) {
                        idx = 0;
                    }
                } else if (--idx < 0) {
                    idx = SetN.this.elements.length - 1;
                }
                this.idx = idx;
                return this.idx;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    Object element;
                    while ((element = SetN.this.elements[this.nextIndex()]) == null) {
                    }
                    --this.remaining;
                    return element;
                }
                throw new NoSuchElementException();
            }
        }
    }

    static final class Set12<E>
    extends AbstractImmutableSet<E>
    implements Serializable {
        final E e0;
        final E e1;

        Set12(E e0) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = null;
        }

        Set12(E e0, E e1) {
            if (e0.equals(Objects.requireNonNull(e1))) {
                throw new IllegalArgumentException("duplicate element: " + e0);
            }
            this.e0 = e0;
            this.e1 = e1;
        }

        @Override
        public int size() {
            return this.e1 == null ? 1 : 2;
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0) || o.equals(this.e1);
        }

        @Override
        public int hashCode() {
            return this.e0.hashCode() + (this.e1 == null ? 0 : this.e1.hashCode());
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int idx;
                {
                    this.idx = this.size();
                }

                @Override
                public boolean hasNext() {
                    return this.idx > 0;
                }

                @Override
                public E next() {
                    if (this.idx == 1) {
                        this.idx = 0;
                        return SALT >= 0 || e1 == null ? e0 : e1;
                    }
                    if (this.idx == 2) {
                        this.idx = 1;
                        return SALT >= 0 ? e1 : e0;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            if (this.e1 == null) {
                return new CollSer(2, this.e0);
            }
            return new CollSer(2, this.e0, this.e1);
        }
    }

    static abstract class AbstractImmutableSet<E>
    extends AbstractImmutableCollection<E>
    implements Set<E> {
        AbstractImmutableSet() {
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            for (Object e : c) {
                if (e != null && this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public abstract int hashCode();
    }

    static final class ListN<E>
    extends AbstractImmutableList<E>
    implements Serializable {
        static List<?> EMPTY_LIST;
        private final E[] elements;

        @SafeVarargs
        ListN(E ... input) {
            Object[] tmp = new Object[input.length];
            for (int i = 0; i < input.length; ++i) {
                tmp[i] = Objects.requireNonNull(input[i]);
            }
            this.elements = tmp;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public E get(int index) {
            return this.elements[index];
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.elements);
        }

        static {
            if (EMPTY_LIST == null) {
                EMPTY_LIST = new ListN<Object>(new Object[0]);
            }
        }
    }

    static final class List12<E>
    extends AbstractImmutableList<E>
    implements Serializable {
        private final E e0;
        private final E e1;

        List12(E e0) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = null;
        }

        List12(E e0, E e1) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = Objects.requireNonNull(e1);
        }

        @Override
        public int size() {
            return this.e1 != null ? 2 : 1;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.e0;
            }
            if (index == 1 && this.e1 != null) {
                return this.e1;
            }
            throw this.outOfBounds(index);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            if (this.e1 == null) {
                return new CollSer(1, this.e0);
            }
            return new CollSer(1, this.e0, this.e1);
        }
    }

    static final class SubList<E>
    extends AbstractImmutableList<E>
    implements RandomAccess {
        private final List<E> root;
        private final int offset;
        private final int size;

        private SubList(List<E> root, int offset, int size) {
            this.root = root;
            this.offset = offset;
            this.size = size;
        }

        static <E> SubList<E> fromSubList(SubList<E> parent, int fromIndex, int toIndex) {
            return new SubList<E>(parent.root, parent.offset + fromIndex, toIndex - fromIndex);
        }

        static <E> SubList<E> fromList(List<E> list, int fromIndex, int toIndex) {
            return new SubList<E>(list, fromIndex, toIndex - fromIndex);
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.size);
            return this.root.get(this.offset + index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<E> iterator() {
            return new ListItr(this, this.size());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.rangeCheck(index);
            return new ListItr(this, this.size(), index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return SubList.fromSubList(this, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index > this.size) {
                throw this.outOfBounds(index);
            }
        }
    }

    static final class ListItr<E>
    implements ListIterator<E> {
        private final List<E> list;
        private final int size;
        private final boolean isListIterator;
        private int cursor;

        ListItr(List<E> list, int size) {
            this.list = list;
            this.size = size;
            this.cursor = 0;
            this.isListIterator = false;
        }

        ListItr(List<E> list, int size, int index) {
            this.list = list;
            this.size = size;
            this.cursor = index;
            this.isListIterator = true;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.size;
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                E next = this.list.get(i);
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            try {
                int i = this.cursor - 1;
                E previous = this.list.get(i);
                this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void add(E e) {
            throw ImmutableCollections.uoe();
        }
    }

    static abstract class AbstractImmutableList<E>
    extends AbstractImmutableCollection<E>
    implements List<E>,
    RandomAccess {
        AbstractImmutableList() {
        }

        @Override
        public void add(int index, E element) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public E remove(int index) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public E set(int index, E element) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            int size = this.size();
            AbstractImmutableList.subListRangeCheck(fromIndex, toIndex, size);
            return SubList.fromList(this, fromIndex, toIndex);
        }

        static void subListRangeCheck(int fromIndex, int toIndex, int size) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > size) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new ListItr(this, this.size());
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            int size = this.size();
            if (index < 0 || index > size) {
                throw this.outOfBounds(index);
            }
            return new ListItr(this, size, index);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator oit = ((List)o).iterator();
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                if (oit.hasNext() && this.get(i).equals(oit.next())) continue;
                return false;
            }
            return !oit.hasNext();
        }

        @Override
        public int indexOf(Object o) {
            Objects.requireNonNull(o);
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            Objects.requireNonNull(o);
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int hashCode() {
            int hash = 1;
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                hash = 31 * hash + this.get(i).hashCode();
            }
            return hash;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        IndexOutOfBoundsException outOfBounds(int index) {
            return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
    }

    static abstract class AbstractImmutableCollection<E>
    extends AbstractCollection<E> {
        AbstractImmutableCollection() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }
    }
}

