/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import desugar.sun.nio.fs.DesugarUnixUriUtils;
import desugar.sun.nio.fs.DesugarUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DesugarUnixPath
implements Path {
    private static final String SEPARATOR = "/";
    private static final Pattern PATH_COMPONENT_SPLITERATOR = Pattern.compile("/+");
    private final FileSystem fileSystem;
    private final String pathText;
    private final List<String> fileNames;
    private final boolean isAbsolutePath;
    private final String userDir;
    private final String rootDir;
    private volatile byte[] byteArrayValue;

    public DesugarUnixPath(FileSystem fileSystem, String rawPath, String userDir, String rootDir) {
        this(fileSystem, rawPath.startsWith(SEPARATOR), DesugarUnixPath.getFileNames(rawPath), userDir, rootDir);
    }

    private DesugarUnixPath(FileSystem fileSystem, boolean isAbsolutePath, List<String> fileNames, String userDir, String rootDir) {
        this.fileSystem = fileSystem;
        this.isAbsolutePath = isAbsolutePath;
        this.fileNames = fileNames;
        this.pathText = DesugarUnixPath.getPathText(isAbsolutePath, fileNames);
        this.userDir = userDir;
        this.rootDir = rootDir;
    }

    private static List<String> getFileNames(String rawTextPath) {
        if (rawTextPath.isEmpty()) {
            return Collections.singletonList("");
        }
        return Arrays.stream(PATH_COMPONENT_SPLITERATOR.split(rawTextPath)).filter(name -> !name.isEmpty()).collect(Collectors.toUnmodifiableList());
    }

    private static String getPathText(boolean isAbsolutePath, Collection<String> fileNames) {
        return (isAbsolutePath ? SEPARATOR : "") + String.join((CharSequence)SEPARATOR, fileNames);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolutePath;
    }

    @Override
    public DesugarUnixPath getRoot() {
        if (this.isAbsolute()) {
            return new DesugarUnixPath(this.getFileSystem(), this.rootDir, this.userDir, this.rootDir);
        }
        return null;
    }

    DesugarUnixPath getUserDir() {
        return new DesugarUnixPath(this.getFileSystem(), this.userDir, this.userDir, this.rootDir);
    }

    @Override
    public DesugarUnixPath getFileName() {
        return this.fileNames.isEmpty() ? (this.isAbsolutePath ? null : this) : new DesugarUnixPath(this.fileSystem, this.fileNames.get(this.getNameCount() - 1), this.userDir, this.rootDir);
    }

    @Override
    public DesugarUnixPath getParent() {
        int nameCount = this.getNameCount();
        if (nameCount == 0 || nameCount == 1 && !this.isAbsolutePath) {
            return null;
        }
        StringBuilder pathBuilder = new StringBuilder();
        if (this.isAbsolutePath) {
            pathBuilder.append(SEPARATOR);
        }
        String pathText = pathBuilder.append(this.subPathName(0, nameCount - 1)).toString();
        return new DesugarUnixPath(this.fileSystem, pathText, this.userDir, this.rootDir);
    }

    @Override
    public int getNameCount() {
        return this.fileNames.size();
    }

    @Override
    public DesugarUnixPath getName(int index) {
        if (index < 0 || index >= this.getNameCount()) {
            throw new IllegalArgumentException(String.format("Requested name for index (%d) is out of bound in \n%s.", index, this));
        }
        return new DesugarUnixPath(this.fileSystem, this.fileNames.get(index), this.userDir, this.rootDir);
    }

    @Override
    public DesugarUnixPath subpath(int beginIndex, int endIndex) {
        return new DesugarUnixPath(this.fileSystem, this.subPathName(beginIndex, endIndex), this.userDir, this.rootDir);
    }

    private String subPathName(int beginIndex, int endIndex) {
        return String.join((CharSequence)SEPARATOR, this.fileNames.subList(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(new DesugarUnixPath(this.fileSystem, other, this.userDir, this.rootDir));
    }

    @Override
    public boolean startsWith(Path other) {
        Objects.requireNonNull(other);
        if (!(other instanceof DesugarUnixPath)) {
            return false;
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            return false;
        }
        int otherNameCount = other.getNameCount();
        if (this.getNameCount() < otherNameCount) {
            return false;
        }
        for (int i = 0; i < otherNameCount; ++i) {
            if (this.getName(i).equals(other.getName(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(new DesugarUnixPath(this.fileSystem, other, this.userDir, this.rootDir));
    }

    @Override
    public boolean endsWith(Path other) {
        Objects.requireNonNull(other);
        if (!(other instanceof DesugarUnixPath)) {
            return false;
        }
        if (other.isAbsolute()) {
            return this.equals(other);
        }
        int otherNameCount = other.getNameCount();
        if (this.getNameCount() < otherNameCount) {
            return false;
        }
        int thisNameCount = this.getNameCount();
        for (int i = otherNameCount - 1; i >= 0; --i) {
            if (this.getName(i - otherNameCount + thisNameCount).equals(other.getName(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DesugarUnixPath)) {
            return false;
        }
        return this.compareTo((DesugarUnixPath)other) == 0;
    }

    @Override
    public int hashCode() {
        return this.pathText.hashCode();
    }

    @Override
    public int compareTo(Path other) {
        return this.pathText.compareTo(((DesugarUnixPath)other).pathText);
    }

    @Override
    public DesugarUnixPath normalize() {
        ArrayDeque<String> normalizedFileNames = new ArrayDeque<String>();
        Iterator<String> iterator = this.fileNames.iterator();
        block8: while (iterator.hasNext()) {
            String fileName;
            switch (fileName = iterator.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    normalizedFileNames.removeLast();
                    continue block8;
                }
            }
            normalizedFileNames.add(fileName);
        }
        return new DesugarUnixPath(this.fileSystem, DesugarUnixPath.getPathText(this.isAbsolutePath, normalizedFileNames), this.userDir, this.rootDir);
    }

    @Override
    public DesugarUnixPath resolve(Path other) {
        if (!(other instanceof DesugarUnixPath)) {
            throw new IllegalArgumentException(String.format("Expected to resolve paths on the same file system as DesugarUnixPath, but gets %s (%s).", other, other.getFileSystem()));
        }
        if (other.isAbsolute()) {
            return (DesugarUnixPath)other;
        }
        return new DesugarUnixPath(this.fileSystem, this.pathText + SEPARATOR + other, this.userDir, this.rootDir);
    }

    @Override
    public DesugarUnixPath resolveSibling(Path other) {
        if (!(Objects.requireNonNull(other) instanceof DesugarUnixPath)) {
            throw new IllegalArgumentException(String.format("Expected to resolve paths on the same file system as DesugarUnixPath, but gets %s (%s).", other, other.getFileSystem()));
        }
        DesugarUnixPath parent = this.getParent();
        return parent == null ? (DesugarUnixPath)other : parent.resolve(other);
    }

    @Override
    public DesugarUnixPath resolveSibling(String other) {
        return this.resolveSibling(new DesugarUnixPath(this.fileSystem, other, this.userDir, this.rootDir));
    }

    @Override
    public DesugarUnixPath relativize(Path other) {
        int j;
        if (!(other instanceof DesugarUnixPath)) {
            throw new IllegalArgumentException(String.format("Expected to resolve paths on the same file system as DesugarUnixPath, but gets %s (%s).", other, other.getFileSystem()));
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("'other' is different type of Path in absolute property.");
        }
        List<String> otherFileNames = ((DesugarUnixPath)other).fileNames;
        int thisFileNameCount = this.fileNames.size();
        int otherFileNameCount = otherFileNames.size();
        for (int i = 0; i < thisFileNameCount && i < otherFileNameCount && this.fileNames.get(i).equals(otherFileNames.get(i)); ++i) {
        }
        ArrayList<String> relativeFileNames = new ArrayList<String>();
        for (j = i; j < thisFileNameCount; ++j) {
            relativeFileNames.add("..");
        }
        for (j = i; j < otherFileNameCount; ++j) {
            relativeFileNames.add(otherFileNames.get(j));
        }
        return new DesugarUnixPath(this.fileSystem, false, relativeFileNames, this.userDir, this.rootDir);
    }

    @Override
    public File toFile() {
        return new File(this.toString());
    }

    @Override
    public URI toUri() {
        return DesugarUnixUriUtils.toUri(this);
    }

    @Override
    public DesugarUnixPath toAbsolutePath() {
        return this.isAbsolute() ? this : this.getUserDir().resolve(this);
    }

    @Override
    public DesugarUnixPath toRealPath(LinkOption ... options) throws IOException {
        this.getFileSystem().provider().checkAccess(this, AccessMode.READ);
        if (Arrays.asList(options).contains(LinkOption.NOFOLLOW_LINKS)) {
            return this.toAbsolutePath();
        }
        return new DesugarUnixPath(this.fileSystem, this.toFile().getCanonicalPath(), this.userDir, this.rootDir);
    }

    @Override
    public String toString() {
        return this.pathText;
    }

    byte[] asByteArray() {
        if (this.byteArrayValue == null) {
            this.byteArrayValue = this.pathText.getBytes(DesugarUtil.jnuEncoding());
        }
        return this.byteArrayValue;
    }

    @Override
    public Iterator<Path> iterator() {
        return Path.super.iterator();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Watch Service is not supported");
    }
}

