/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.Tripwire;

interface Sink<T>
extends Consumer<T> {
    default public void begin(long size) {
    }

    default public void end() {
    }

    default public boolean cancellationRequested() {
        return false;
    }

    @Override
    default public void accept(int value) {
        throw new IllegalStateException("called wrong accept method");
    }

    @Override
    default public void accept(long value) {
        throw new IllegalStateException("called wrong accept method");
    }

    @Override
    default public void accept(double value) {
        throw new IllegalStateException("called wrong accept method");
    }

    public static abstract class ChainedDouble<E_OUT>
    implements OfDouble {
        protected final Sink<? super E_OUT> downstream;

        public ChainedDouble(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }
    }

    public static abstract class ChainedLong<E_OUT>
    implements OfLong {
        protected final Sink<? super E_OUT> downstream;

        public ChainedLong(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }
    }

    public static abstract class ChainedInt<E_OUT>
    implements OfInt {
        protected final Sink<? super E_OUT> downstream;

        public ChainedInt(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }
    }

    public static abstract class ChainedReference<T, E_OUT>
    implements Sink<T> {
        protected final Sink<? super E_OUT> downstream;

        public ChainedReference(Sink<? super E_OUT> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void begin(long size) {
            this.downstream.begin(size);
        }

        @Override
        public void end() {
            this.downstream.end();
        }

        @Override
        public boolean cancellationRequested() {
            return this.downstream.cancellationRequested();
        }
    }

    public static interface OfDouble
    extends Sink<Double>,
    DoubleConsumer {
        @Override
        public void accept(double var1);

        @Override
        default public void accept(Double i) {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Sink.OfDouble.accept(Double)");
            }
            this.accept((double)i);
        }
    }

    public static interface OfLong
    extends Sink<Long>,
    LongConsumer {
        @Override
        public void accept(long var1);

        @Override
        default public void accept(Long i) {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Sink.OfLong.accept(Long)");
            }
            this.accept((long)i);
        }
    }

    public static interface OfInt
    extends Sink<Integer>,
    IntConsumer {
        @Override
        public void accept(int var1);

        @Override
        default public void accept(Integer i) {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Sink.OfInt.accept(Integer)");
            }
            this.accept((int)i);
        }
    }
}

