/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.DesugarArrays;
import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSpliterators;
import java.util.stream.StreamSupport;
import java.util.stream.Streams;

public interface DoubleStream
extends BaseStream<Double, DoubleStream> {
    public DoubleStream filter(DoublePredicate var1);

    public DoubleStream map(DoubleUnaryOperator var1);

    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> var1);

    public IntStream mapToInt(DoubleToIntFunction var1);

    public LongStream mapToLong(DoubleToLongFunction var1);

    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> var1);

    public DoubleStream distinct();

    public DoubleStream sorted();

    public DoubleStream peek(DoubleConsumer var1);

    public DoubleStream limit(long var1);

    public DoubleStream skip(long var1);

    public void forEach(DoubleConsumer var1);

    public void forEachOrdered(DoubleConsumer var1);

    public double[] toArray();

    public double reduce(double var1, DoubleBinaryOperator var3);

    public OptionalDouble reduce(DoubleBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjDoubleConsumer<R> var2, BiConsumer<R, R> var3);

    public double sum();

    public OptionalDouble min();

    public OptionalDouble max();

    public long count();

    public OptionalDouble average();

    public DoubleSummaryStatistics summaryStatistics();

    public boolean anyMatch(DoublePredicate var1);

    public boolean allMatch(DoublePredicate var1);

    public boolean noneMatch(DoublePredicate var1);

    public OptionalDouble findFirst();

    public OptionalDouble findAny();

    public Stream<Double> boxed();

    @Override
    public DoubleStream sequential();

    @Override
    public DoubleStream parallel();

    public PrimitiveIterator.OfDouble iterator();

    public Spliterator.OfDouble spliterator();

    public static Builder builder() {
        return new Streams.DoubleStreamBuilderImpl();
    }

    public static DoubleStream empty() {
        return StreamSupport.doubleStream(Spliterators.emptyDoubleSpliterator(), false);
    }

    public static DoubleStream of(double t) {
        return StreamSupport.doubleStream(new Streams.DoubleStreamBuilderImpl(t), false);
    }

    public static DoubleStream of(double ... values) {
        return DesugarArrays.stream(values);
    }

    public static DoubleStream iterate(final double seed, final DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        PrimitiveIterator.OfDouble iterator = new PrimitiveIterator.OfDouble(){
            double t;
            {
                this.t = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public double nextDouble() {
                double v = this.t;
                this.t = f.applyAsDouble(this.t);
                return v;
            }
        };
        return StreamSupport.doubleStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static DoubleStream generate(DoubleSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.doubleStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfDouble(Long.MAX_VALUE, s), false);
    }

    public static DoubleStream concat(DoubleStream a, DoubleStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfDouble split = new Streams.ConcatSpliterator.OfDouble(a.spliterator(), b.spliterator());
        DoubleStream stream = StreamSupport.doubleStream(split, a.isParallel() || b.isParallel());
        return (DoubleStream)stream.onClose(Streams.composedClose(a, b));
    }

    public static interface Builder
    extends DoubleConsumer {
        @Override
        public void accept(double var1);

        default public Builder add(double t) {
            this.accept(t);
            return this;
        }

        public DoubleStream build();
    }
}

