/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.Log;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Objects;

public class LogCatHeader {
    private static final DateTimeFormatter EPOCH_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.INSTANT_SECONDS).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.ROOT);
    private final Log.LogLevel logLevel;
    private final int pid;
    private final int tid;
    private final String appName;
    private final String tag;
    private final Instant timestamp;

    public LogCatHeader(Log.LogLevel level, int pid, int tid, String name, String tag, Instant timestamp) {
        this.logLevel = level;
        this.pid = pid;
        this.tid = tid;
        this.appName = name;
        this.tag = tag;
        this.timestamp = timestamp;
    }

    public Log.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public int getPid() {
        return this.pid;
    }

    public int getTid() {
        return this.tid;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getTag() {
        return this.tag;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Log.LogLevel component1() {
        return this.getLogLevel();
    }

    public int component2() {
        return this.getPid();
    }

    public int component3() {
        return this.getTid();
    }

    public String component4() {
        return this.getAppName();
    }

    public String component5() {
        return this.getTag();
    }

    public Instant component6() {
        return this.getTimestamp();
    }

    public String toString() {
        String epoch = EPOCH_TIME_FORMATTER.format(this.timestamp);
        char priority = this.logLevel.getPriorityLetter();
        return String.format(Locale.ROOT, "%s: %c/%s(%d:%d) %s", epoch, Character.valueOf(priority), this.tag, this.pid, this.tid, this.appName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logLevel, this.pid, this.tid, this.appName, this.tag, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogCatHeader)) {
            return false;
        }
        LogCatHeader other = (LogCatHeader)obj;
        return this.logLevel == other.logLevel && this.pid == other.pid && this.tid == other.tid && this.appName.equals(other.appName) && this.tag.equals(other.tag) && this.timestamp.equals(other.timestamp);
    }
}

