/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.commands;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.internal.DeviceMonitor;
import com.android.ddmlib.internal.commands.ICommand;

public class DisconnectCommand
implements ICommand {
    public static final String COMMAND = "disconnect";
    private DeviceMonitor myMonitor;

    public DisconnectCommand(DeviceMonitor monitor) {
        this.myMonitor = monitor;
    }

    @Override
    public void run(String argsString) {
        try {
            if (argsString == null) {
                throw new IllegalArgumentException("Expected arguments got null.");
            }
            String[] params = argsString.split(":");
            if (params.length != 2) {
                throw new IllegalArgumentException("Expected 2 parameters got " + params.length);
            }
            String deviceId = params[0];
            int pid = Integer.parseInt(params[1]);
            for (IDevice device : this.myMonitor.getDevices()) {
                if (!device.getSerialNumber().equals(deviceId)) continue;
                this.myMonitor.disconnectClient(device, pid);
                return;
            }
            Log.w("DisconnectCommand", "No client found for given args (" + argsString + ")");
        }
        catch (Exception ex) {
            Log.e("DisconnectCommand", ex);
        }
    }
}

