/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.Log;
import com.android.ddmlib.internal.commands.ICommand;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 $2\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0003J\b\u0010!\u001a\u00020\u0018H\u0016J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/ddmlib/internal/CommandService;", "Ljava/lang/Runnable;", "mListenPort", "", "(I)V", "boundPort", "getBoundPort", "()I", "commandMap", "Ljava/util/HashMap;", "", "Lcom/android/ddmlib/internal/commands/ICommand;", "Lkotlin/collections/HashMap;", "listenChannel", "Ljava/nio/channels/ServerSocketChannel;", "quit", "", "runThread", "Ljava/lang/Thread;", "serverAddress", "Ljava/net/InetSocketAddress;", "startTimer", "Ljava/util/Timer;", "addCommand", "", "command", "handler", "processOneCommand", "client", "Ljava/nio/channels/SocketChannel;", "readExactly", "Ljava/nio/ByteBuffer;", "amount", "run", "start", "stop", "Companion", "ServerHostTimer", "ddmlib"})
public final class CommandService
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int mListenPort;
    @Nullable
    private ServerSocketChannel listenChannel;
    @Nullable
    private InetSocketAddress serverAddress;
    private boolean quit;
    @Nullable
    private Thread runThread;
    @Nullable
    private Timer startTimer;
    @NotNull
    private final HashMap<String, ICommand> commandMap;
    private static final long JOIN_TIMEOUT_MS = 5000L;
    private static final long RETRY_SERVER_MILLIS = 30000L;

    public CommandService(int mListenPort) {
        this.mListenPort = mListenPort;
        this.quit = true;
        this.commandMap = new HashMap();
    }

    public final int getBoundPort() {
        int n;
        ServerSocket serverSocket;
        ServerSocketChannel serverSocketChannel = this.listenChannel;
        return serverSocketChannel == null ? -1 : ((serverSocket = serverSocketChannel.socket()) == null ? -1 : (n = serverSocket.getLocalPort()));
    }

    public final void addCommand(@NotNull String command, @NotNull ICommand handler) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Map map = this.commandMap;
        boolean bl = false;
        map.put(command, handler);
    }

    public final void stop() {
        this.quit = true;
        if (this.listenChannel != null) {
            try {
                ServerSocketChannel serverSocketChannel = this.listenChannel;
                Intrinsics.checkNotNull((Object)serverSocketChannel);
                serverSocketChannel.close();
                ServerSocketChannel serverSocketChannel2 = this.listenChannel;
                Intrinsics.checkNotNull((Object)serverSocketChannel2);
                serverSocketChannel2.socket().close();
            }
            catch (IOException ex) {
                Log.w("CommandService", ex);
            }
        }
        if (this.runThread != null) {
            try {
                Thread thread = this.runThread;
                Intrinsics.checkNotNull((Object)thread);
                thread.join(5000L);
                Thread thread2 = this.runThread;
                Intrinsics.checkNotNull((Object)thread2);
                if (thread2.isAlive()) {
                    Log.e("CommandService", "Run thread still alive after 5000ms");
                }
            }
            catch (InterruptedException ex) {
                Log.w("CommandService", ex);
            }
        }
        this.listenChannel = null;
        this.runThread = null;
    }

    public final void start() {
        if (this.startTimer == null) {
            Timer timer = this.startTimer = new Timer();
            Intrinsics.checkNotNull((Object)timer);
            timer.schedule((TimerTask)new ServerHostTimer(), 0L, 30000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.quit) {
            try {
                Closeable closeable;
                ServerSocketChannel serverSocketChannel = this.listenChannel;
                SocketChannel socketChannel = closeable = serverSocketChannel == null ? null : serverSocketChannel.accept();
                if (closeable == null) continue;
                SocketChannel client = closeable;
                closeable = client;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Closeable it = closeable;
                    boolean bl3 = false;
                    this.processOneCommand((SocketChannel)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException ex) {
                Log.e("CommandService", ex);
                return;
            }
        }
    }

    public final void processOneCommand(@NotNull SocketChannel client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ByteBuffer buffer = this.readExactly(client, 4);
        int cmdSize = Integer.parseInt(StandardCharsets.UTF_8.decode(buffer).toString(), 16);
        buffer = this.readExactly(client, cmdSize);
        String string = StandardCharsets.UTF_8.decode(buffer).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.decode(buffer).toString()");
        String data = string;
        int commandTerminator = StringsKt.indexOf$default((CharSequence)data, (String)":", (int)0, (boolean)false, (int)6, null);
        if (commandTerminator == -1 && this.commandMap.containsKey(data)) {
            ICommand iCommand = this.commandMap.get(data);
            Intrinsics.checkNotNull((Object)iCommand);
            iCommand.run(null);
        } else if (commandTerminator != -1) {
            String string2 = data;
            int n = 0;
            int n2 = 0;
            String string3 = string2.substring(n, commandTerminator);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String command = string3;
            String string4 = data;
            n2 = commandTerminator + 1;
            boolean bl = false;
            String string5 = string4.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String argsString = string5;
            if (!this.commandMap.containsKey(command)) {
                Log.w("CommandService", "Unknown command received");
                return;
            }
            try {
                ICommand iCommand = this.commandMap.get(command);
                Intrinsics.checkNotNull((Object)iCommand);
                iCommand.run(argsString);
            }
            catch (Throwable t) {
                Log.w("CommandService", t);
            }
        } else {
            Log.w("CommandService", "Failed to find command");
        }
    }

    @NotNull
    public final ByteBuffer readExactly(@NotNull SocketChannel client, int amount) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ByteBuffer buffer = ByteBuffer.allocate(amount);
        while (buffer.hasRemaining()) {
            int count = client.read(buffer);
            if (count != -1) continue;
            throw new EOFException("Unexpected end of channel");
        }
        buffer.position(0);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        return buffer;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/ddmlib/internal/CommandService$ServerHostTimer;", "Ljava/util/TimerTask;", "(Lcom/android/ddmlib/internal/CommandService;)V", "run", "", "ddmlib"})
    public final class ServerHostTimer
    extends TimerTask {
        public ServerHostTimer() {
            Intrinsics.checkNotNullParameter((Object)CommandService.this, (String)"this$0");
        }

        @Override
        public void run() {
            try {
                CommandService.this.serverAddress = new InetSocketAddress(InetAddress.getByName("localhost"), CommandService.this.mListenPort);
                CommandService.this.listenChannel = ServerSocketChannel.open();
                ServerSocketChannel serverSocketChannel = CommandService.this.listenChannel;
                Intrinsics.checkNotNull((Object)serverSocketChannel);
                serverSocketChannel.socket().setReuseAddress(true);
                ServerSocketChannel serverSocketChannel2 = CommandService.this.listenChannel;
                Intrinsics.checkNotNull((Object)serverSocketChannel2);
                serverSocketChannel2.socket().bind(CommandService.this.serverAddress);
            }
            catch (BindException ex) {
                Log.i("CommandService", "Port is already bound");
                return;
            }
            catch (IOException ex) {
                Log.e("CommandService", ex);
                return;
            }
            CommandService.this.quit = false;
            CommandService.this.runThread = new Thread((Runnable)CommandService.this, "CommandServiceConnection");
            Thread thread = CommandService.this.runThread;
            Intrinsics.checkNotNull((Object)thread);
            thread.start();
            Timer timer = CommandService.this.startTimer;
            Intrinsics.checkNotNull((Object)timer);
            timer.cancel();
            CommandService.this.startTimer = null;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/ddmlib/internal/CommandService$Companion;", "", "()V", "JOIN_TIMEOUT_MS", "", "RETRY_SERVER_MILLIS", "ddmlib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

