/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.AdbSocketUtils;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.DeviceImpl;
import com.android.ddmlib.internal.MonitorThread;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class DeviceClientMonitorTask
implements Runnable {
    private static final String ADB_TRACK_JDWP_COMMAND = "track-jdwp";
    private volatile boolean mQuit;
    private final Selector mSelector;
    private final ConcurrentHashMap<SocketChannel, DeviceImpl> mChannelsToRegister = new ConcurrentHashMap();
    private final Set<ClientImpl> mClientsToReopen = new HashSet<ClientImpl>();

    DeviceClientMonitorTask() throws IOException {
        this.mSelector = Selector.open();
    }

    boolean register(DeviceImpl device) {
        SocketChannel socketChannel;
        try {
            socketChannel = AndroidDebugBridge.openConnection();
        }
        catch (IOException exception) {
            Log.e("DeviceClientMonitorTask", "Unable to open connection to ADB server: " + exception);
            return false;
        }
        if (socketChannel != null) {
            try {
                boolean result = DeviceClientMonitorTask.sendDeviceMonitoringRequest(socketChannel, device);
                if (result) {
                    device.setClientMonitoringSocket(socketChannel);
                    socketChannel.configureBlocking(false);
                    this.mChannelsToRegister.put(socketChannel, device);
                    this.mSelector.wakeup();
                    return true;
                }
            }
            catch (TimeoutException e) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Connection Failure when starting to monitor device '" + device + "' : timeout");
            }
            catch (AdbCommandRejectedException e) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Adb refused to start monitoring device '" + device + "' : " + e.getMessage());
            }
            catch (IOException e) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.d("DeviceClientMonitorTask", "Connection Failure when starting to monitor device '" + device + "' : " + e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClientToDropAndReopen(ClientImpl client) {
        Set<ClientImpl> set = this.mClientsToReopen;
        synchronized (set) {
            Log.d("DeviceClientMonitorTask", "Adding " + client + " to list of client to reopen (" + client.getDebuggerListenPort() + ").");
            this.mClientsToReopen.add(client);
        }
        this.mSelector.wakeup();
    }

    void free(ClientImpl client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDropAndReopenClients() {
        Set<ClientImpl> set = this.mClientsToReopen;
        synchronized (set) {
            MonitorThread monitorThread = MonitorThread.getInstance();
            for (ClientImpl client : this.mClientsToReopen) {
                DeviceImpl device = (DeviceImpl)client.getDevice();
                int pid = client.getClientData().getPid();
                monitorThread.dropClient(client, false);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                Log.d("DeviceClientMonitorTask", "Reopening " + client);
                DeviceClientMonitorTask.openClient(device, pid, monitorThread);
                device.update(2);
            }
            this.mClientsToReopen.clear();
        }
    }

    void processChannelsToRegister() {
        this.mChannelsToRegister.entrySet().removeIf(entry -> {
            try {
                ((SocketChannel)entry.getKey()).register(this.mSelector, 1, entry.getValue());
            }
            catch (ClosedChannelException e) {
                Log.e("DeviceClientMonitorTask", "Connection error while monitoring clients.");
            }
            return true;
        });
    }

    @Override
    public void run() {
        byte[] lengthBuffer = new byte[4];
        do {
            try {
                int count = this.mSelector.select();
                if (this.mQuit) {
                    return;
                }
                this.processChannelsToRegister();
                this.processDropAndReopenClients();
                if (count == 0) continue;
                Set<SelectionKey> keys = this.mSelector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    DeviceImpl device;
                    SocketChannel socket;
                    Object attachment;
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid() || !key.isReadable() || !((attachment = key.attachment()) instanceof DeviceImpl) || (socket = (device = (DeviceImpl)attachment).getClientMonitoringSocket()) == null) continue;
                    try {
                        int length = AdbSocketUtils.readLength(socket, lengthBuffer);
                        this.processIncomingJdwpData(device, socket, length);
                    }
                    catch (IOException ioe) {
                        Log.d("DeviceClientMonitorTask", "Error reading jdwp list: " + ioe.getMessage());
                        socket.close();
                        this.mChannelsToRegister.remove(socket);
                        device.getClientTracker().trackDeviceToDropAndReopen(device);
                    }
                }
            }
            catch (IOException ex) {
                Log.e("DeviceClientMonitorTask", "Connection error while monitoring clients.");
            }
        } while (!this.mQuit);
    }

    public void stop() {
        this.mQuit = true;
        this.mSelector.wakeup();
    }

    private static boolean sendDeviceMonitoringRequest(SocketChannel socket, DeviceImpl device) throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            AdbHelper.setDevice(socket, device);
            AdbHelper.write(socket, AdbHelper.formAdbRequest(ADB_TRACK_JDWP_COMMAND));
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(socket, false);
            if (!resp.okay) {
                Log.e("DeviceClientMonitorTask", "adb refused request: " + resp.message);
            }
            return resp.okay;
        }
        catch (TimeoutException e) {
            Log.e("DeviceClientMonitorTask", "Sending jdwp tracking request timed out!");
            throw e;
        }
        catch (IOException e) {
            Log.e("DeviceClientMonitorTask", "Sending jdwp tracking request failed!");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processIncomingJdwpData(DeviceImpl device, SocketChannel monitorSocket, int length) throws IOException {
        String[] stringArray;
        if (length < 0) return;
        HashSet<Integer> newPids = new HashSet<Integer>();
        if (length > 0) {
            void var10_12;
            String[] pids;
            byte[] buffer = new byte[length];
            String result = AdbSocketUtils.read(monitorSocket, buffer);
            stringArray = pids = result.split("\n");
            int n = stringArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                String pid = stringArray[var10_12];
                try {
                    newPids.add(Integer.valueOf(pid));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++var10_12;
            }
        }
        MonitorThread monitorThread = MonitorThread.getInstance();
        String[] clients = device.getClientList();
        HashMap<Integer, ClientImpl> existingClients = new HashMap<Integer, ClientImpl>();
        stringArray = clients;
        synchronized (clients) {
            for (ClientImpl clientImpl : clients) {
                existingClients.put(clientImpl.getClientData().getPid(), clientImpl);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            HashSet clientsToRemove = new HashSet();
            for (Integer n : existingClients.keySet()) {
                if (newPids.contains(n)) continue;
                clientsToRemove.add(existingClients.get(n));
            }
            HashSet pidsToAdd = new HashSet(newPids);
            pidsToAdd.removeAll(existingClients.keySet());
            monitorThread.dropClients(clientsToRemove, false);
            Iterator iterator = pidsToAdd.iterator();
            while (iterator.hasNext()) {
                int newPid = (Integer)iterator.next();
                DeviceClientMonitorTask.openClient(device, newPid, monitorThread);
            }
            if (pidsToAdd.isEmpty() && clientsToRemove.isEmpty()) return;
            AndroidDebugBridge.deviceChanged(device, 2);
            return;
        }
    }

    private static void openClient(DeviceImpl device, int pid, MonitorThread monitorThread) {
        SocketChannel clientSocket;
        try {
            clientSocket = AdbHelper.createPassThroughConnection(new InetSocketAddress("localhost", 8599), device.getSerialNumber(), pid);
            clientSocket.configureBlocking(false);
        }
        catch (UnknownHostException uhe) {
            Log.d("DeviceClientMonitorTask", "Unknown Jdwp pid: " + pid);
            return;
        }
        catch (TimeoutException e) {
            Log.w("DeviceClientMonitorTask", "Failed to connect to client '" + pid + "': timeout");
            return;
        }
        catch (AdbCommandRejectedException e) {
            Log.d("DeviceClientMonitorTask", "Adb rejected connection to client '" + pid + "': " + e.getMessage());
            return;
        }
        catch (IOException ioe) {
            Log.w("DeviceClientMonitorTask", "Failed to connect to client '" + pid + "': " + ioe.getMessage());
            return;
        }
        DeviceClientMonitorTask.createClient(device, pid, clientSocket, monitorThread);
    }

    private static void createClient(DeviceImpl device, int pid, SocketChannel socket, MonitorThread monitorThread) {
        ClientImpl client = new ClientImpl(device, socket, pid);
        if (client.sendHandshake()) {
            try {
                if (AndroidDebugBridge.getClientSupport()) {
                    client.listenForDebugger();
                    String msg = String.format(Locale.US, "Opening a debugger listener at port %1$d for client with pid %2$d", client.getDebuggerListenPort(), pid);
                    Log.d("ddms", msg);
                }
            }
            catch (IOException ioe) {
                client.getClientData().setDebuggerConnectionStatus(ClientData.DebuggerStatus.ERROR);
                Log.e("ddms", "Can't bind to local " + client.getDebuggerListenPort() + " for debugger");
            }
            client.requestAllocationStatus();
        } else {
            Log.e("ddms", "Handshake with " + client + " failed!");
        }
        if (client.isValid()) {
            device.addClient(client);
            monitorThread.addClient(client);
        }
    }
}

