/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BB\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012#\b\u0002\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0011\u001a\u0004\u0018\u00018\u00002\b\u0010\u0010\u001a\u0004\u0018\u00018\u00008B@BX\u0082\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0004\u0018\u00018\u00002\b\u0010\u0010\u001a\u0004\u0018\u00018\u00008V@RX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/utils/concurrency/CachedAsyncSupplier;", "V", "Lcom/android/utils/concurrency/AsyncSupplier;", "compute", "Lkotlin/Function0;", "isUpToDate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ExecutorService;)V", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "kotlin.jvm.PlatformType", "newValue", "lastComputedValue", "getLastComputedValue", "()Ljava/lang/Object;", "setLastComputedValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "lastComputedValueLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "now", "getNow", "setNow", "runningComputation", "Lcom/google/common/util/concurrent/ListenableFuture;", "runningComputationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "get", "common"})
public final class CachedAsyncSupplier<V>
implements AsyncSupplier<V> {
    @NotNull
    private final Function0<V> compute;
    @NotNull
    private final Function1<V, Boolean> isUpToDate;
    private final ListeningExecutorService executor;
    @NotNull
    private final ReentrantLock runningComputationLock;
    @NotNull
    private ListenableFuture<V> runningComputation;
    @NotNull
    private final ReentrantReadWriteLock lastComputedValueLock;
    @Nullable
    private V lastComputedValue;

    @JvmOverloads
    public CachedAsyncSupplier(@NotNull Function0<? extends V> compute, @NotNull Function1<? super V, Boolean> isUpToDate, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        Intrinsics.checkNotNullParameter(isUpToDate, (String)"isUpToDate");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.compute = compute;
        this.isUpToDate = isUpToDate;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.runningComputationLock = new ReentrantLock();
        ListenableFuture listenableFuture = Futures.immediateFuture(null);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(null)");
        this.runningComputation = listenableFuture;
        this.lastComputedValueLock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ CachedAsyncSupplier(Function0 function0, Function1 function1, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(function0, function1, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V getLastComputedValue() {
        V v;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lastComputedValueLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            v = this.lastComputedValue;
        }
        finally {
            readLock.unlock();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setLastComputedValue(V newValue) {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lastComputedValueLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            this.lastComputedValue = newValue;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    @Nullable
    public V getNow() {
        ListenableFuture<V> currentComputation = this.get();
        return (V)(currentComputation.isDone() ? Futures.getDone((Future)((Future)currentComputation)) : this.getLastComputedValue());
    }

    private void setNow(V newValue) {
        this.setLastComputedValue(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ListenableFuture<V> get() {
        V cachedValue = this.getLastComputedValue();
        if (cachedValue != null && ((Boolean)this.isUpToDate.invoke(cachedValue)).booleanValue()) {
            ListenableFuture listenableFuture = Futures.immediateFuture(cachedValue);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(cachedValue)");
            return listenableFuture;
        }
        Lock lock = this.runningComputationLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (this.runningComputation.isDone()) {
                ListenableFuture listenableFuture = Futures.nonCancellationPropagating((ListenableFuture)this.executor.submit(new Callable(this){
                    final /* synthetic */ CachedAsyncSupplier<V> this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final V call() {
                        Object computedValue = CachedAsyncSupplier.access$getCompute$p(this.this$0).invoke();
                        CachedAsyncSupplier.access$setLastComputedValue(this.this$0, computedValue);
                        return (V)computedValue;
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"override fun get(): List\u2026ningComputation\n    }\n  }");
                this.runningComputation = listenableFuture;
            }
            ListenableFuture<V> listenableFuture = this.runningComputation;
            return listenableFuture;
        }
        finally {
            lock.unlock();
        }
    }

    @JvmOverloads
    public CachedAsyncSupplier(@NotNull Function0<? extends V> compute, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this(compute, null, executor, 2, null);
    }

    public static final /* synthetic */ Function0 access$getCompute$p(CachedAsyncSupplier $this) {
        return $this.compute;
    }

    public static final /* synthetic */ void access$setLastComputedValue(CachedAsyncSupplier $this, Object newValue) {
        $this.setLastComputedValue(newValue);
    }
}

