/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.cxx;

import com.android.utils.cxx.Sections;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\n \u000b*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\n \u000b*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0010\u0010(\u001a\n \u000b*\u0004\u0018\u00010\u001b0\u001bH\u0002J\b\u0010)\u001a\u00020\"H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001fH\u0002J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\"H\u0002J\u0012\u0010/\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u001fH\u0002J\u0016\u0010/\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J,\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00142\u0006\u00104\u001a\u00020\u0003J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0014\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u000b*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u000b*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/utils/cxx/CompileCommandsEncoder;", "Ljava/lang/AutoCloseable;", "file", "Ljava/io/File;", "initialBufferSize", "", "(Ljava/io/File;I)V", "bufferStartPosition", "", "channel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "compileCommandsIndexEntry", "countOfSourceMessages", "countOfSourceMessagesOffset", "getFile", "()Ljava/io/File;", "flagListsIndexEntry", "flagsTable", "", "", "lastCompilerWritten", "lastFlagsWritten", "lastWorkingDirectoryWritten", "lock", "Ljava/nio/channels/FileLock;", "map", "Ljava/nio/ByteBuffer;", "ras", "Ljava/io/RandomAccessFile;", "stringTable", "", "stringTableIndexEntry", "close", "", "encodeByte", "byte", "", "encodeInt", "int", "encodeLongZero", "encodeMagic", "encodeUTF8", "string", "ensureAtLeast", "bytes", "flushBuffer", "intern", "flags", "writeCompileCommand", "sourceFile", "compiler", "workingDirectory", "writeSectionIndexEntry", "section", "Lcom/android/utils/cxx/Sections;", "common"})
public final class CompileCommandsEncoder
implements AutoCloseable {
    private final RandomAccessFile ras;
    private final FileChannel channel;
    private final FileLock lock;
    private long bufferStartPosition;
    private ByteBuffer map;
    private final long stringTableIndexEntry;
    private final long flagListsIndexEntry;
    private final long compileCommandsIndexEntry;
    private final long countOfSourceMessagesOffset;
    private final Map<String, Integer> stringTable;
    private final Map<List<Integer>, Integer> flagsTable;
    private int countOfSourceMessages;
    private int lastCompilerWritten;
    private int lastFlagsWritten;
    private int lastWorkingDirectoryWritten;
    @NotNull
    private final File file;

    private final void encodeMagic() {
        String string = "C/C++ Build Metadata\u001a";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ByteBuffer map = this.ensureAtLeast(bytes.length);
        map.put(bytes);
    }

    private final void encodeUTF8(String string) {
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ByteBuffer map = this.ensureAtLeast(4 + bytes.length);
        map.putInt(bytes.length);
        map.put(bytes);
    }

    private final ByteBuffer encodeByte(byte by) {
        return this.ensureAtLeast(1).put(by);
    }

    private final ByteBuffer encodeInt(int n) {
        return this.ensureAtLeast(4).putInt(n);
    }

    private final ByteBuffer encodeLongZero() {
        return this.ensureAtLeast(8).putLong(0L);
    }

    private final ByteBuffer ensureAtLeast(int bytes) {
        if (this.map.capacity() < this.map.position() + bytes) {
            this.flushBuffer();
            if (this.map.capacity() < bytes) {
                this.map = ByteBuffer.allocate(bytes);
            }
        }
        ByteBuffer byteBuffer = this.map;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"map");
        return byteBuffer;
    }

    private final void flushBuffer() {
        if (this.map.position() == 0) {
            return;
        }
        this.ras.seek(this.bufferStartPosition);
        this.ras.write(this.map.array(), 0, this.map.position());
        this.bufferStartPosition += (long)this.map.position();
        ByteBuffer byteBuffer = this.map;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).clear();
    }

    private final int intern(String string) {
        Integer n = string == null ? Integer.valueOf(0) : this.stringTable.computeIfAbsent(string, new Function<String, Integer>(this){
            final /* synthetic */ CompileCommandsEncoder this$0;

            @NotNull
            public final Integer apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return CompileCommandsEncoder.access$getStringTable$p(this.this$0).size() + 1;
            }
            {
                this.this$0 = compileCommandsEncoder;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"if (string == null) 0\n  \u2026ve 0 for 'null'\n        }");
        return n;
    }

    private final int intern(List<Integer> flags) {
        Integer n = this.flagsTable.computeIfAbsent(flags, (Function<List<Integer>, Integer>)new Function<List<? extends Integer>, Integer>(this){
            final /* synthetic */ CompileCommandsEncoder this$0;

            @NotNull
            public final Integer apply(@NotNull List<Integer> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return CompileCommandsEncoder.access$getFlagsTable$p(this.this$0).size();
            }
            {
                this.this$0 = compileCommandsEncoder;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"flagsTable.computeIfAbse\u2026    flagsTable.size\n    }");
        return ((Number)n).intValue();
    }

    private final long writeSectionIndexEntry(Sections section) {
        long result = this.ras.getFilePointer() + (long)this.map.position();
        this.encodeInt(section.ordinal());
        this.encodeLongZero();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCompileCommand(@NotNull File sourceFile, @NotNull File compiler, @NotNull List<String> flags, @NotNull File workingDirectory) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)compiler, (String)"compiler");
        Intrinsics.checkParameterIsNotNull(flags, (String)"flags");
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        int compilerIndex = this.intern(compiler.getPath());
        Iterable iterable = flags;
        CompileCommandsEncoder compileCommandsEncoder = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = this.intern((String)it);
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        int flagsIndex = compileCommandsEncoder.intern((List<Integer>)collection);
        int workingDirectoryIndex = this.intern(workingDirectory.getPath());
        if (compilerIndex != this.lastCompilerWritten || flagsIndex != this.lastFlagsWritten || workingDirectoryIndex != this.lastWorkingDirectoryWritten) {
            this.encodeByte((byte)0);
            this.encodeInt(compilerIndex);
            this.encodeInt(flagsIndex);
            this.encodeInt(workingDirectoryIndex);
            this.lastCompilerWritten = compilerIndex;
            this.lastFlagsWritten = flagsIndex;
            this.lastWorkingDirectoryWritten = workingDirectoryIndex;
            CompileCommandsEncoder compileCommandsEncoder2 = this;
            ++compileCommandsEncoder2.countOfSourceMessages;
            int cfr_ignored_0 = compileCommandsEncoder2.countOfSourceMessages;
        }
        this.encodeByte((byte)1);
        this.encodeInt(this.intern(sourceFile.getPath()));
        CompileCommandsEncoder compileCommandsEncoder3 = this;
        ++compileCommandsEncoder3.countOfSourceMessages;
        int cfr_ignored_1 = compileCommandsEncoder3.countOfSourceMessages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        long offsetOfStringTable = this.bufferStartPosition + (long)this.map.position();
        this.encodeInt(this.stringTable.size());
        Iterable $this$sortedBy$iv2 = MapsKt.toList(this.stringTable);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$index = (Pair)a;
                boolean bl2 = false;
                int index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                $dstr$_u24__u24$index = (Pair)b;
                Comparable comparable = Integer.valueOf(index);
                bl2 = false;
                index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                Integer n = index;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair $dstr$string$_u24__u24 = (Pair)element$iv;
            boolean bl2 = false;
            String string = (String)$dstr$string$_u24__u24.component1();
            this.encodeUTF8(string);
        }
        long offsetOfFlagLists = this.bufferStartPosition + (long)this.map.position();
        this.encodeInt(this.flagsTable.size());
        Iterable iterable = MapsKt.toList(this.flagsTable);
        boolean $i$f$sortedBy2 = false;
        boolean bl3 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$index = (Pair)a;
                boolean bl2 = false;
                int index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                $dstr$_u24__u24$index = (Pair)b;
                Comparable comparable = Integer.valueOf(index);
                bl2 = false;
                index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                Integer n = index;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        });
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$flags$_u24__u24 = (Pair)element$iv;
            boolean bl4 = false;
            List flags = (List)$dstr$flags$_u24__u24.component1();
            this.encodeInt(flags.size());
            Iterable $this$forEach$iv3 = flags;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                int flag = ((Number)element$iv2).intValue();
                boolean bl5 = false;
                this.encodeInt(flag);
            }
        }
        this.flushBuffer();
        this.map = null;
        this.ras.seek(this.countOfSourceMessagesOffset);
        this.ras.writeInt(this.countOfSourceMessages);
        this.ras.seek(this.compileCommandsIndexEntry + (long)4);
        this.ras.writeLong(this.countOfSourceMessagesOffset);
        this.ras.seek(this.stringTableIndexEntry + (long)4);
        this.ras.writeLong(offsetOfStringTable);
        this.ras.seek(this.flagListsIndexEntry + (long)4);
        this.ras.writeLong(offsetOfFlagLists);
        this.ras.getFD().sync();
        this.lock.close();
        this.channel.close();
        this.ras.close();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public CompileCommandsEncoder(@NotNull File file, int initialBufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.ras = new RandomAccessFile(this.file, "rw");
        this.channel = this.ras.getChannel();
        this.lock = this.channel.lock();
        this.map = ByteBuffer.allocate(initialBufferSize);
        boolean bl = false;
        this.stringTable = new LinkedHashMap();
        bl = false;
        this.flagsTable = new LinkedHashMap();
        this.lastCompilerWritten = -1;
        this.lastFlagsWritten = -1;
        this.lastWorkingDirectoryWritten = -1;
        this.encodeMagic();
        this.encodeInt(1);
        this.encodeInt(3);
        this.compileCommandsIndexEntry = this.writeSectionIndexEntry(Sections.CompileCommands);
        this.stringTableIndexEntry = this.writeSectionIndexEntry(Sections.StringTable);
        this.flagListsIndexEntry = this.writeSectionIndexEntry(Sections.FlagLists);
        this.countOfSourceMessagesOffset = this.ras.getFilePointer() + (long)this.map.position();
        this.encodeInt(0);
    }

    public /* synthetic */ CompileCommandsEncoder(File file, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 32768;
        }
        this(file, n);
    }

    public static final /* synthetic */ Map access$getStringTable$p(CompileCommandsEncoder $this) {
        return $this.stringTable;
    }

    public static final /* synthetic */ Map access$getFlagsTable$p(CompileCommandsEncoder $this) {
        return $this.flagsTable;
    }
}

