/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLineKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u0007J\u0016\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0007J\b\u0010(\u001a\u00020\u0003H\u0016J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030+J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "charAt", "", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "toString", "separator", "toTokenList", "", "tokenMatches", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    private final int generation;
    private String toStringValue;
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    private int[] indexes;

    public final void removeTokenGroup(@NotNull String token, int extra) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.checkGeneration();
        this.invalidate();
        int read = 1;
        int write = 1;
        do {
            boolean bl = read >= write;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = this.isStartOfToken(read);
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = this.isStartOfToken(write);
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (this.tokenMatches(token, read)) {
                for (int count = 0; count != extra + 1 && !this.isEndOfCommand(read); ++count) {
                    read = this.nextTokenAfter(read);
                }
            } else {
                if (this.isEndOfCommand(read) || this.isEndOfCommand(write)) continue;
                do {
                    this.indexes[write++] = this.indexes[read++];
                } while (!this.isEndOfToken(read - 1));
            }
        } while (!this.isEndOfCommand(read));
        this.indexes[write] = Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String removeNth(int n) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token = new StringBuilder();
        int tokenNumber = 0;
        int write = 1;
        int n2 = 1;
        int n3 = this.indexes.length;
        while (n2 < n3) {
            int offset;
            void read;
            if (tokenNumber != n) {
                this.indexes[write++] = this.indexes[read];
            }
            if ((offset = this.indexes[read]) == Integer.MIN_VALUE) {
                CharSequence charSequence = token;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return null;
                }
                return token.toString();
            }
            if (offset == Integer.MAX_VALUE) {
                ++tokenNumber;
            } else if (tokenNumber == n) {
                token.append(this.commandLine.charAt(offset));
            }
            ++read;
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        boolean bl = false;
        List result = new ArrayList();
        StringBuilder token = new StringBuilder();
        int i2 = 1;
        while (!this.isEndOfCommand(i2)) {
            Character c = this.charAt(i2);
            if (c == null) {
                CharSequence charSequence = token;
                boolean bl2 = false;
                if (charSequence.length() > 0) {
                    String string = token.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"token.toString()");
                    result.add(string);
                    token.setLength(0);
                }
            } else {
                token.append(c.charValue());
            }
            ++i2;
        }
        return result;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i2 = 0;
        int length = this.commandLine.length();
        Character c = null;
        int offset = 1;
        while (i2 < length && Character.isWhitespace(this.commandLine.charAt(i2))) {
            n = i2;
            i2 = n + 1;
        }
        block1: while (i2 < length) {
            c = Character.valueOf(this.commandLine.charAt(i2));
            if (c.charValue() == '\"') {
                if (raw) {
                    n = offset;
                    offset = n + 1;
                    this.indexes[n] = i2;
                }
                quoting = !quoting;
                ++i2;
                continue;
            }
            if (c.charValue() == '\\') {
                boolean quote;
                int forward = i2 + 1;
                int slashCount = 1;
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)forward);
                while (true) {
                    Character c2 = c;
                    if (c2 == null || c2.charValue() != '\\') break;
                    ++slashCount;
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++forward));
                }
                boolean odd = slashCount % 2 == 1;
                Character c3 = c;
                boolean bl = quote = c3 != null && c3.charValue() == '\"';
                if (!raw && quote) {
                    slashCount /= 2;
                }
                int n2 = 0;
                int n3 = 0;
                n3 = 0;
                int n4 = slashCount;
                while (n3 < n4) {
                    int j = n3++;
                    boolean bl2 = false;
                    int n5 = offset;
                    offset = n5 + 1;
                    this.indexes[n5] = i2 + j;
                }
                if (odd && quote) {
                    n2 = offset;
                    offset = n2 + 1;
                    this.indexes[n2] = forward++;
                }
                i2 = forward;
                continue;
            }
            if (!quoting && c.charValue() == '^') {
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i2));
                if (raw || c == null) {
                    n = offset;
                    offset = n + 1;
                    this.indexes[n] = i2 - 1;
                }
                Character c4 = c;
                if (c4 != null && c4.charValue() == '^') {
                    n = offset;
                    offset = n + 1;
                    int n6 = n;
                    n = i2;
                    i2 = n + 1;
                    this.indexes[n6] = n;
                }
                while (true) {
                    Character c5 = c;
                    if (c5 == null || c5.charValue() != '\r') {
                        Character c6 = c;
                        if (c6 == null || c6.charValue() != '\n') continue block1;
                    }
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i2));
                }
            }
            if (!quoting && Character.isWhitespace(c.charValue())) {
                n = offset;
                offset = n + 1;
                this.indexes[n] = Integer.MAX_VALUE;
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i2));
                while (c != null && Character.isWhitespace(c.charValue())) {
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i2));
                }
                continue;
            }
            n = offset;
            offset = n + 1;
            int n7 = n;
            n = i2;
            i2 = n + 1;
            this.indexes[n7] = n;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n = offset;
            offset = n + 1;
            this.indexes[n] = Integer.MAX_VALUE;
        }
        n = offset;
        offset = n + 1;
        this.indexes[n] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i2 = 0;
        char c = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i2 < length) {
            c = this.commandLine.charAt(i2++);
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c)) && raw) {
                this.indexes[offset++] = i2 - 1;
            }
            if (escaping) {
                escaping = false;
                if (c == '\n' || raw) continue;
                this.indexes[offset++] = i2 - 1;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                this.indexes[offset++] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            this.indexes[offset++] = i2 - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            this.indexes[offset++] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.checkGeneration();
        int i2 = 0;
        int index = this.indexes[offset];
        while (index != Integer.MIN_VALUE) {
            boolean endOfToken;
            boolean bl = endOfToken = index == Integer.MAX_VALUE;
            if (i2 == token.length()) {
                return endOfToken;
            }
            if (endOfToken) {
                return false;
            }
            if (token.charAt(i2) != this.commandLine.charAt(index)) {
                return false;
            }
            index = this.indexes[offset + ++i2];
        }
        return false;
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result = offset;
        while (!this.isEndOfToken(result) && !this.isEndOfCommand(result)) {
            ++result;
        }
        return result + 1;
    }

    private final boolean isEndOfToken(int i2) {
        return i2 < this.indexes.length && this.indexes[i2] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i2) {
        return i2 >= this.indexes.length || this.indexes[i2] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i2) {
        return i2 == 1 || this.isEndOfToken(i2 - 1);
    }

    private final Character charAt(int i2) {
        return this.isEndOfToken(i2) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i2]));
    }

    public final int normalizedCommandLineLength() {
        int n;
        if (this.isEndOfCommand(1)) {
            n = 0;
        } else {
            int i2 = 1;
            while (!this.isEndOfCommand(i2 + 1)) {
                ++i2;
            }
            n = i2 - 1;
        }
        return n;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i2 = 1;
        while (!this.isEndOfCommand(i2) && !this.isEndOfCommand(i2 + 1)) {
            Character c = this.charAt(i2);
            hash ^= (long)(c != null ? c.charValue() : 32);
            hash *= 1099511628211L;
            ++i2;
        }
        return (int)hash;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        int n = 1;
        int n2 = length1;
        while (n < n2) {
            void i2;
            Character c = this.charAt((int)i2);
            if ((c != null ? c.charValue() : (char)' ') != other.charAt((int)(i2 - true))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        this.checkGeneration();
        int i2 = 1;
        if (this.isEndOfCommand(i2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfCommand(i2 + 1)) {
            Object object = this.charAt(i2);
            if (object == null) {
                object = separator;
            }
            sb.append(object);
            ++i2;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string = this.toStringValue;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }
        String string = this.toStringValue = this.toString(" ");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        int n = this.indexes[0];
        int n2 = this.generation;
        boolean bl = false;
        int n3 = Math.abs(n);
        if (n2 != n3) {
            throw (Throwable)new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)indexes, (String)"indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = this.indexes[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string, boolean bl, int n, int[] nArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = SdkConstants.currentPlatform();
        }
        if ((n2 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string);
        }
        this(string, bl, n, nArray);
    }
}

