/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.StringHelperPOSIX;
import com.android.utils.StringHelperWindows;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;

public class StringHelper {
    private static final CharMatcher CR = CharMatcher.is((char)'\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    public static void appendCapitalized(StringBuilder sb, String word) {
        if (word.isEmpty()) {
            return;
        }
        int c = word.charAt(0);
        if (c >= 55296 && c <= 56319) {
            c = word.codePointAt(0);
            int charCount = Character.charCount(c);
            String upperString = word.substring(0, charCount).toUpperCase(Locale.US);
            sb.append(upperString);
            sb.append(word, charCount, word.length());
        } else {
            int result = Character.toUpperCase(c);
            char upperChar = result != -1 ? (char)result : word.substring(0, 1).toUpperCase(Locale.US).charAt(0);
            sb.append(upperChar);
            sb.append(word, 1, word.length());
        }
    }

    public static String capitalize(String word) {
        StringBuilder sb = new StringBuilder(word.length());
        StringHelper.appendCapitalized(sb, word);
        return sb.toString();
    }

    public static String appendCapitalized(String prefix, String word) {
        StringBuilder sb = new StringBuilder(prefix.length() + word.length());
        sb.append(prefix);
        StringHelper.appendCapitalized(sb, word);
        return sb.toString();
    }

    public static String appendCapitalized(String prefix, String word1, String word2) {
        StringBuilder sb = new StringBuilder(prefix.length() + word1.length() + word2.length());
        sb.append(prefix);
        StringHelper.appendCapitalized(sb, word1);
        StringHelper.appendCapitalized(sb, word2);
        return sb.toString();
    }

    public static String appendCapitalized(String prefix, String ... words) {
        int length = prefix.length();
        int max = words.length;
        for (int i = 0; i < max; ++i) {
            length += words[i].length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(prefix);
        for (String word : words) {
            StringHelper.appendCapitalized(sb, word);
        }
        return sb.toString();
    }

    public static String capitalizeWithSuffix(String word, String suffix) {
        StringBuilder sb = new StringBuilder(word.length() + suffix.length());
        StringHelper.appendCapitalized(sb, word);
        sb.append(suffix);
        return sb.toString();
    }

    public static void appendCamelCase(StringBuilder sb, String word) {
        if (sb.length() == 0) {
            sb.append(word);
        } else {
            StringHelper.appendCapitalized(sb, word);
        }
    }

    public static String combineAsCamelCase(Iterable<String> stringList) {
        int count = 0;
        for (String s : stringList) {
            count += s.length();
        }
        StringBuilder sb = new StringBuilder(count);
        boolean first = true;
        for (String str : stringList) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, str);
        }
        return sb.toString();
    }

    public static <T> String combineAsCamelCase(Collection<T> objectList, Function<T, String> mapFunction) {
        StringBuilder sb = new StringBuilder(objectList.size() * 20);
        StringHelper.combineAsCamelCase(sb, objectList, mapFunction);
        return sb.toString();
    }

    public static <T> void combineAsCamelCase(StringBuilder sb, Collection<T> objectList, Function<T, String> mapFunction) {
        boolean first = true;
        for (T object : objectList) {
            if (first) {
                sb.append(mapFunction.apply(object));
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, mapFunction.apply(object));
        }
    }

    public static List<String> toStrings(Object ... objects) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add((Object)((String)path));
                continue;
            }
            if (path instanceof Collection) {
                Collection pathCollection = (Collection)path;
                for (Object item : pathCollection) {
                    if (item instanceof String) {
                        builder.add((Object)((String)item));
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        return builder.build();
    }

    public static List<String> tokenizeCommandLineToEscaped(String commandLine) {
        if (SdkConstants.currentPlatform() == 2) {
            return StringHelperWindows.tokenizeCommandLineToEscaped(commandLine);
        }
        return StringHelperPOSIX.tokenizeCommandLineToEscaped(commandLine);
    }

    public static List<String> tokenizeCommandLineToRaw(String commandLine) {
        if (SdkConstants.currentPlatform() == 2) {
            return StringHelperWindows.tokenizeCommandLineToRaw(commandLine);
        }
        return StringHelperPOSIX.tokenizeCommandLineToRaw(commandLine);
    }

    public static String toSystemLineSeparator(String input) {
        return StringHelper.toLineSeparator(System.lineSeparator(), input);
    }

    private static String toLineSeparator(String separator, String input) {
        String unixStyle = CR.matchesAnyOf((CharSequence)input) ? CR.removeFrom((CharSequence)input) : input;
        return separator.equals("\n") ? unixStyle : LF.matcher(unixStyle).replaceAll("\r\n");
    }
}

