/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

@Immutable
public final class Message {
    @NonNull
    private final Kind mKind;
    @NonNull
    private final String mText;
    @NonNull
    private final List<SourceFilePosition> mSourceFilePositions;
    @NonNull
    private final String mRawMessage;

    public Message(@NonNull Kind kind, @NonNull String text, @NonNull SourceFilePosition sourceFilePosition, SourceFilePosition ... sourceFilePositions) {
        this.mKind = kind;
        this.mText = text;
        this.mRawMessage = text;
        this.mSourceFilePositions = ImmutableList.builder().add((Object)sourceFilePosition).add((Object[])sourceFilePositions).build();
    }

    public Message(@NonNull Kind kind, @NonNull String text, @NonNull String rawMessage, @NonNull SourceFilePosition sourceFilePosition, SourceFilePosition ... sourceFilePositions) {
        this.mKind = kind;
        this.mText = text;
        this.mRawMessage = rawMessage;
        this.mSourceFilePositions = ImmutableList.builder().add((Object)sourceFilePosition).add((Object[])sourceFilePositions).build();
    }

    public Message(@NonNull Kind kind, @NonNull String text, @NonNull String rawMessage, @NonNull ImmutableList<SourceFilePosition> positions) {
        this.mKind = kind;
        this.mText = text;
        this.mRawMessage = rawMessage;
        this.mSourceFilePositions = positions.isEmpty() ? ImmutableList.of((Object)SourceFilePosition.UNKNOWN) : positions;
    }

    @NonNull
    public Kind getKind() {
        return this.mKind;
    }

    @NonNull
    public String getText() {
        return this.mText;
    }

    @NonNull
    public List<SourceFilePosition> getSourceFilePositions() {
        return this.mSourceFilePositions;
    }

    @NonNull
    public String getRawMessage() {
        return this.mRawMessage;
    }

    @Nullable
    public String getSourcePath() {
        File file = this.mSourceFilePositions.get(0).getFile().getSourceFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    @Deprecated
    public int getLineNumber() {
        return this.mSourceFilePositions.get(0).getPosition().getStartLine() + 1;
    }

    @Deprecated
    public int getColumn() {
        return this.mSourceFilePositions.get(0).getPosition().getStartColumn() + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message that = (Message)o;
        return Objects.equal((Object)((Object)this.mKind), (Object)((Object)that.mKind)) && Objects.equal((Object)this.mText, (Object)that.mText) && Objects.equal(this.mSourceFilePositions, that.mSourceFilePositions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mKind, this.mText, this.mSourceFilePositions});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("kind", (Object)this.mKind).add("text", (Object)this.mText).add("sources", this.mSourceFilePositions).toString();
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO,
        STATISTICS,
        UNKNOWN,
        SIMPLE;


        public static Kind findIgnoringCase(String s, Kind defaultKind) {
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equalsIgnoreCase(s)) continue;
                return kind;
            }
            return defaultKind;
        }

        @Nullable
        public static Kind findIgnoringCase(String s) {
            return Kind.findIgnoringCase(s, null);
        }
    }
}

