/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.QemuExecutor;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/testing/QemuExecutor;", "", "emulatorDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "processFactory", "Lkotlin/Function1;", "", "", "Ljava/lang/ProcessBuilder;", "(Lorg/gradle/api/provider/Provider;Lkotlin/jvm/functions/Function1;)V", "qemuImageExecutable", "Ljava/io/File;", "getQemuImageExecutable", "()Ljava/io/File;", "deleteSnapshot", "", "avdName", "deviceDir", "snapshotName", "logger", "Lcom/android/utils/ILogger;", "gradle-core"})
public final class QemuExecutor {
    @NotNull
    private final Provider<Directory> emulatorDir;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;

    public QemuExecutor(@NotNull Provider<Directory> emulatorDir, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory2) {
        Intrinsics.checkNotNullParameter(emulatorDir, (String)"emulatorDir");
        Intrinsics.checkNotNullParameter(processFactory2, (String)"processFactory");
        this.emulatorDir = emulatorDir;
        this.processFactory = processFactory2;
    }

    public /* synthetic */ QemuExecutor(Provider provider2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Provider<Directory>)provider2, (Function1<? super List<String>, ProcessBuilder>)function1);
    }

    @NotNull
    public final File getQemuImageExecutable() {
        File file = ((Directory)this.emulatorDir.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        return FilesKt.resolve((File)file, (String)"qemu-img");
    }

    public final void deleteSnapshot(@NotNull String avdName, @NotNull File deviceDir, @NotNull String snapshotName, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)deviceDir, (String)"deviceDir");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose("Deleting snapshot " + snapshotName + " for " + avdName + ".", new Object[0]);
        boolean failedToDelete = false;
        File[] fileArray = deviceDir.listFiles(deleteSnapshot.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        for (File qcowFile : fileArray) {
            Object[] objectArray = new String[]{this.getQemuImageExecutable().getAbsolutePath(), "snapshot", "-d", snapshotName, qcowFile.getAbsolutePath()};
            Process process2 = ((ProcessBuilder)this.processFactory.invoke((Object)CollectionsKt.listOf((Object[])objectArray))).start();
            if (process2.waitFor(10L, TimeUnit.SECONDS) && process2.exitValue() == 0) continue;
            process2.destroyForcibly();
            logger.warning(StringsKt.trimIndent((String)("\n                        Failed to delete snapshot " + snapshotName + " for device " + avdName + " in qemu\n                        snapshot file " + qcowFile + ". qemu-img exit code: " + process2.exitValue() + "\n                    ")), new Object[0]);
            failedToDelete = true;
        }
        String[] stringArray = new String[]{"snapshots", snapshotName};
        File snapshotDir = FileUtils.join((File)deviceDir, (String[])stringArray);
        if (snapshotDir.exists() && snapshotDir.isDirectory()) {
            try {
                logger.warning("Deleting unbootable snapshot for device: " + avdName, new Object[0]);
                FileUtils.deleteRecursivelyIfExists((File)snapshotDir);
            }
            catch (IOException ioException) {
                logger.error((Throwable)ioException, "Could not delete snapshot folder at location: " + snapshotDir.getAbsolutePath() + ".", new Object[0]);
                failedToDelete = true;
            }
        }
        if (!failedToDelete) {
            logger.verbose("Successfully deleted snapshot " + snapshotName + " for " + avdName + ".", new Object[0]);
        }
    }
}

