/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.CxxConfigurationFolding;
import com.android.build.gradle.internal.cxx.configure.CxxConfigurationFoldingKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModelKt;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.StringHelper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J@\u0010%\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\n2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u00182\u0010\u0010'\u001a\f\u0012\u0004\u0012\u00020\b0\u0019j\u0002`\u001aH\u0002J.\u0010(\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\n2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018H\u0002J\u001c\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\n\u0010,\u001a\u00060\bj\u0002`\tH\u0002J\u0014\u0010-\u001a\u00060\bj\u0002`\t2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0002J\u001a\u00100\u001a\u00020\b2\u0010\u00101\u001a\f\u0012\u0004\u0012\u00020\b0\u0019j\u0002`\u001aH\u0002J\u001a\u00102\u001a\u00020\b2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018H\u0002J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\bH\u0002JF\u00105\u001a\u00020**(\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\u000b0\u0003\u0012\u0004\u0012\u00020\u00040\n0\u00072\n\u00106\u001a\u00060\bj\u0002`\t2\u0006\u0010+\u001a\u00020\u0004H\u0002R7\u0010\u0006\u001a(\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\u000b0\u0003\u0012\u0004\u0012\u00020\u00040\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR+\u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\n0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R+\u0010\u0012\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0017\u001a2\u0012$\u0012\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0019j\u0002`\u001a0\n\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\u001b\u001a(\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\u000b0\u0003\u0012\u0004\u0012\u00020\u00040\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR+\u0010\u001d\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR(\u0010\u001f\u001a\u001c\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\u0018\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010!\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\rR+\u0010#\u001a\u001c\u0012\b\u0012\u00060\bj\u0002`\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\r\u00a8\u00067"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CxxConfigurationFolding;", "", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "(Ljava/util/List;)V", "buildAbis", "", "", "Lcom/android/build/gradle/internal/cxx/configure/TaskName;", "Lkotlin/Pair;", "Lcom/android/build/gradle/internal/cxx/configure/VariantName;", "getBuildAbis", "()Ljava/util/Map;", "buildConfigureEdges", "", "getBuildConfigureEdges", "()Ljava/util/Set;", "buildGroups", "getBuildGroups", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "buildSystemName", "builders", "Lcom/android/build/gradle/internal/cxx/configure/Configuration;", "", "Lcom/android/build/gradle/internal/cxx/configure/Targets;", "configureAbis", "getConfigureAbis", "configureGroups", "getConfigureGroups", "configurers", "namesSeen", "variantToBuild", "getVariantToBuild", "variantToConfiguration", "getVariantToConfiguration", "buildTaskNameOf", "configuration", "targets", "configureTaskNameOf", "createBuildTask", "", "abi", "configureTaskName", "createConfigurationTask", "legalize", "name", "targetAnnotation", "unsorted", "taskNameAnnotation", "uniquify", "base", "setRepresentativeAbiForTask", "taskName", "gradle-core"})
public final class CxxConfigurationFolding {
    @NotNull
    private final Map<List<String>, String> configurers;
    @NotNull
    private final Map<Pair<List<String>, Set<String>>, String> builders;
    @NotNull
    private final Set<String> namesSeen;
    @NotNull
    private final NativeBuildSystem buildSystem;
    @NotNull
    private final String buildSystemName;
    @NotNull
    private final Map<String, Pair<List<String>, CxxAbiModel>> configureAbis;
    @NotNull
    private final Map<String, Set<String>> configureGroups;
    @NotNull
    private final Map<String, Pair<List<String>, CxxAbiModel>> buildAbis;
    @NotNull
    private final Map<String, Set<String>> buildGroups;
    @NotNull
    private final Map<String, Set<String>> variantToConfiguration;
    @NotNull
    private final Map<String, Set<String>> variantToBuild;
    @NotNull
    private final Set<Pair<String, String>> buildConfigureEdges;

    public CxxConfigurationFolding(@NotNull List<CxxAbiModel> abis) {
        Intrinsics.checkNotNullParameter(abis, (String)"abis");
        this.configurers = new LinkedHashMap();
        this.builders = new LinkedHashMap();
        this.namesSeen = new LinkedHashSet();
        this.buildSystem = ((CxxAbiModel)CollectionsKt.first(abis)).getVariant().getModule().getBuildSystem();
        this.buildSystemName = CxxModuleModelKt.getBuildSystemNameForTasks(((CxxAbiModel)CollectionsKt.first(abis)).getVariant().getModule());
        this.configureAbis = new LinkedHashMap();
        this.configureGroups = new LinkedHashMap();
        this.buildAbis = new LinkedHashMap();
        this.buildGroups = new LinkedHashMap();
        this.variantToConfiguration = new LinkedHashMap();
        this.variantToBuild = new LinkedHashMap();
        this.buildConfigureEdges = new LinkedHashSet();
        for (CxxAbiModel abi : abis) {
            if (!abi.isActiveAbi()) continue;
            String configureTaskName = this.createConfigurationTask(abi);
            this.createBuildTask(abi, configureTaskName);
        }
    }

    @NotNull
    public final Map<String, Pair<List<String>, CxxAbiModel>> getConfigureAbis() {
        return this.configureAbis;
    }

    @NotNull
    public final Map<String, Set<String>> getConfigureGroups() {
        return this.configureGroups;
    }

    @NotNull
    public final Map<String, Pair<List<String>, CxxAbiModel>> getBuildAbis() {
        return this.buildAbis;
    }

    @NotNull
    public final Map<String, Set<String>> getBuildGroups() {
        return this.buildGroups;
    }

    @NotNull
    public final Map<String, Set<String>> getVariantToConfiguration() {
        return this.variantToConfiguration;
    }

    @NotNull
    public final Map<String, Set<String>> getVariantToBuild() {
        return this.variantToBuild;
    }

    @NotNull
    public final Set<Pair<String, String>> getBuildConfigureEdges() {
        return this.buildConfigureEdges;
    }

    private final String createConfigurationTask(CxxAbiModel abi) {
        Pair<String, String> pair = this.configureTaskNameOf(abi.getConfigurationArguments());
        String groupTaskName = (String)pair.component1();
        String configureTaskName = (String)pair.component2();
        this.setRepresentativeAbiForTask(this.configureAbis, configureTaskName, abi);
        this.configureGroups.computeIfAbsent(groupTaskName, createConfigurationTask.1.INSTANCE).add(configureTaskName);
        this.variantToConfiguration.computeIfAbsent(abi.getVariant().getVariantName(), createConfigurationTask.2.INSTANCE).add(configureTaskName);
        return configureTaskName;
    }

    private final void createBuildTask(CxxAbiModel abi, String configureTaskName) {
        Pair<String, String> pair = this.buildTaskNameOf(abi.getConfigurationArguments(), abi.getVariant().getBuildTargetSet());
        String groupTaskName = (String)pair.component1();
        String buildTaskName = (String)pair.component2();
        this.setRepresentativeAbiForTask(this.buildAbis, buildTaskName, abi);
        ((Collection)this.buildConfigureEdges).add(TuplesKt.to((Object)buildTaskName, (Object)configureTaskName));
        this.buildGroups.computeIfAbsent(groupTaskName, createBuildTask.1.INSTANCE).add(buildTaskName);
        this.variantToBuild.computeIfAbsent(abi.getVariant().getVariantName(), createBuildTask.2.INSTANCE).add(buildTaskName);
    }

    private final String legalize(String name) {
        String result2 = name;
        Character[] characterArray = CxxConfigurationFoldingKt.access$getIllegalGradleTaskChars$p();
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char ch = characterArray[i].charValue();
            if (!StringsKt.contains$default((CharSequence)result2, (char)ch, (boolean)false, (int)2, null)) continue;
            result2 = StringsKt.replace$default((String)result2, (char)ch, (char)'_', (boolean)false, (int)4, null);
        }
        return result2;
    }

    private final String uniquify(String base) {
        Object name = base;
        int index = 1;
        while (this.namesSeen.contains(name)) {
            name = base + "-" + ++index;
        }
        ((Collection)this.namesSeen).add(name);
        return name;
    }

    private final String targetAnnotation(Set<String> unsorted) {
        List targets = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)unsorted));
        return targets.isEmpty() ? "" : (targets.size() == 1 ? "[" + targets.get(0) + "]" : (targets.size() == 2 ? "[" + targets.get(0) + "," + targets.get(1) + "]" : "[" + targets.get(0) + "," + targets.get(1) + ",etc]"));
    }

    private final String taskNameAnnotation(List<String> configuration) {
        String buildType = CxxConfigurationFoldingKt.buildTypeOf(this.buildSystem, configuration);
        return StringHelper.appendCapitalized((String)this.buildSystemName, (String)buildType);
    }

    private final Pair<String, String> configureTaskNameOf(List<String> configuration) {
        String annotation = this.taskNameAnnotation(configuration);
        String groupTaskName = "configure" + annotation;
        String string = this.configurers.computeIfAbsent(configuration, new Function(this, configuration, groupTaskName){
            final /* synthetic */ CxxConfigurationFolding this$0;
            final /* synthetic */ List<String> $configuration;
            final /* synthetic */ String $groupTaskName;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$groupTaskName = $groupTaskName;
            }

            public final String apply(List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String abi = CxxConfigurationFoldingKt.abiOf(CxxConfigurationFolding.access$getBuildSystem$p(this.this$0), this.$configuration);
                return CxxConfigurationFolding.access$uniquify(this.this$0, CxxConfigurationFolding.access$legalize(this.this$0, this.$groupTaskName + "[" + abi + "]"));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return TuplesKt.to((Object)groupTaskName, (Object)string);
    }

    private final Pair<String, String> buildTaskNameOf(List<String> configuration, Set<String> targets) {
        String annotation = this.taskNameAnnotation(configuration);
        String groupTaskName = "build" + annotation;
        String string = this.builders.computeIfAbsent((Pair<List<String>, Set<String>>)TuplesKt.to(configuration, targets), new Function(this, configuration, targets, groupTaskName){
            final /* synthetic */ CxxConfigurationFolding this$0;
            final /* synthetic */ List<String> $configuration;
            final /* synthetic */ Set<String> $targets;
            final /* synthetic */ String $groupTaskName;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$targets = $targets;
                this.$groupTaskName = $groupTaskName;
            }

            public final String apply(Pair<? extends List<String>, ? extends Set<String>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String abi = CxxConfigurationFoldingKt.abiOf(CxxConfigurationFolding.access$getBuildSystem$p(this.this$0), this.$configuration);
                String targetAnnotation = CxxConfigurationFolding.access$targetAnnotation(this.this$0, this.$targets);
                return CxxConfigurationFolding.access$uniquify(this.this$0, CxxConfigurationFolding.access$legalize(this.this$0, this.$groupTaskName + "[" + abi + "]" + targetAnnotation));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return TuplesKt.to((Object)groupTaskName, (Object)string);
    }

    private final void setRepresentativeAbiForTask(Map<String, Pair<List<String>, CxxAbiModel>> $this$setRepresentativeAbiForTask, String taskName, CxxAbiModel abi) {
        Map<String, Pair<List<String>, CxxAbiModel>> map = $this$setRepresentativeAbiForTask;
        Pair<List<String>, CxxAbiModel> prior = map.get(taskName);
        if (prior == null) {
            map.put(taskName, (Pair<List<String>, CxxAbiModel>)TuplesKt.to((Object)CollectionsKt.listOf((Object)abi.getVariant().getVariantName()), (Object)abi));
        } else {
            List priorVariants = (List)prior.component1();
            CxxAbiModel priorAbi = (CxxAbiModel)prior.component2();
            if (!Intrinsics.areEqual((Object)CxxAbiModelKt.getName(priorAbi), (Object)CxxAbiModelKt.getName(abi))) {
                throw new IllegalStateException(("Expected " + CxxAbiModelKt.getName(priorAbi) + " but got " + CxxAbiModelKt.getName(abi)).toString());
            }
            if (!Intrinsics.areEqual(priorAbi.getConfigurationArguments(), abi.getConfigurationArguments())) {
                throw new IllegalStateException("Expected same configuration arguments".toString());
            }
            map.put(taskName, (Pair<List<String>, CxxAbiModel>)TuplesKt.to((Object)CollectionsKt.plus((Collection)priorVariants, (Object)abi.getVariant().getVariantName()), (Object)abi));
        }
    }

    public static final /* synthetic */ NativeBuildSystem access$getBuildSystem$p(CxxConfigurationFolding $this) {
        return $this.buildSystem;
    }

    public static final /* synthetic */ String access$uniquify(CxxConfigurationFolding $this, String base) {
        return $this.uniquify(base);
    }

    public static final /* synthetic */ String access$legalize(CxxConfigurationFolding $this, String name) {
        return $this.legalize(name);
    }

    public static final /* synthetic */ String access$targetAnnotation(CxxConfigurationFolding $this, Set unsorted) {
        return $this.targetAnnotation(unsorted);
    }
}

