/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AndroidDependenciesRenderer;
import com.android.build.gradle.internal.component.NestedComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.HELP)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/DependencyReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "mavenCoordinateCache", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "getMavenCoordinateCache", "()Lorg/gradle/api/provider/Property;", "nestedComponents", "Lorg/gradle/api/provider/ListProperty;", "Lcom/android/build/gradle/internal/component/NestedComponentCreationConfig;", "getNestedComponents", "()Lorg/gradle/api/provider/ListProperty;", "variants", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "getVariants", "generate", "", "gradle-core"})
public abstract class DependencyReportTask
extends DefaultTask {
    @Internal
    @NotNull
    public abstract Property<MavenCoordinatesCacheBuildService> getMavenCoordinateCache();

    @Internal
    @NotNull
    public abstract ListProperty<VariantCreationConfig> getVariants();

    @Internal
    @NotNull
    public abstract ListProperty<NestedComponentCreationConfig> getNestedComponents();

    @TaskAction
    public final void generate() throws IOException {
        AndroidDependenciesRenderer renderer = new AndroidDependenciesRenderer((MavenCoordinatesCacheBuildService)this.getMavenCoordinateCache().get());
        renderer.setOutput(((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass()));
        Object object = this.getVariants().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List sortedVariants = CollectionsKt.sortedWith((Iterable)((Iterable)object), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VariantCreationConfig it = (VariantCreationConfig)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (VariantCreationConfig)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        for (VariantCreationConfig variant : sortedVariants) {
            renderer.startComponent(variant);
            renderer.render(variant);
        }
        Object object2 = this.getNestedComponents().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List sortedNestedComponents = CollectionsKt.sortedWith((Iterable)((Iterable)object2), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NestedComponentCreationConfig it = (NestedComponentCreationConfig)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (NestedComponentCreationConfig)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        for (NestedComponentCreationConfig component2 : sortedNestedComponents) {
            renderer.startComponent(component2);
            renderer.render(component2);
        }
        this.getLogger().warn("DependencyReportTask has been deprecated and will be removed in AGP 9.0");
    }
}

