/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.kmp;

import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.dependency.AdditionalArtifactType;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputsImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.FullDependencyGraphBuilderKt;
import com.android.build.gradle.internal.ide.dependencies.LibraryService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.dependencies.VariantKey;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.builder.model.v2.ide.Library;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\tJ\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\tR&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/ide/kmp/LibraryResolver;", "", "project", "Lorg/gradle/api/Project;", "libraryService", "Lcom/android/build/gradle/internal/ide/dependencies/LibraryService;", "sourceSetToCreationConfigMap", "Lkotlin/Lazy;", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "Lcom/android/build/gradle/internal/component/KmpComponentCreationConfig;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/ide/dependencies/LibraryService;Lkotlin/Lazy;)V", "artifactsMap", "", "Lcom/android/build/gradle/internal/ide/dependencies/VariantKey;", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "inputsMap", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactCollectionsInputs;", "javaDocArtifactsMap", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Ljava/io/File;", "sampleArtifactsMap", "sourceArtifactsMap", "getArtifacts", "sourceSet", "getInputs", "getJavaDoc", "getLibrary", "Lcom/android/builder/model/v2/ide/Library;", "variant", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "getSamples", "getSources", "registerSourceSetArtifacts", "", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nLibraryResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryResolver.kt\ncom/android/build/gradle/internal/ide/kmp/LibraryResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,110:1\n372#2,7:111\n*S KotlinDebug\n*F\n+ 1 LibraryResolver.kt\ncom/android/build/gradle/internal/ide/kmp/LibraryResolver\n*L\n57#1:111,7\n*E\n"})
public final class LibraryResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final LibraryService libraryService;
    @NotNull
    private final Lazy<Map<KotlinSourceSet, KmpComponentCreationConfig>> sourceSetToCreationConfigMap;
    @NotNull
    private final Map<KotlinSourceSet, ArtifactCollectionsInputs> inputsMap;
    @NotNull
    private final Map<KotlinSourceSet, Map<VariantKey, ResolvedArtifact>> artifactsMap;
    @NotNull
    private final Map<KotlinSourceSet, Map<ComponentIdentifier, File>> javaDocArtifactsMap;
    @NotNull
    private final Map<KotlinSourceSet, Map<ComponentIdentifier, File>> sourceArtifactsMap;
    @NotNull
    private final Map<KotlinSourceSet, Map<ComponentIdentifier, File>> sampleArtifactsMap;

    public LibraryResolver(@NotNull Project project, @NotNull LibraryService libraryService, @NotNull Lazy<? extends Map<KotlinSourceSet, ? extends KmpComponentCreationConfig>> sourceSetToCreationConfigMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)libraryService, (String)"libraryService");
        Intrinsics.checkNotNullParameter(sourceSetToCreationConfigMap, (String)"sourceSetToCreationConfigMap");
        this.project = project;
        this.libraryService = libraryService;
        this.sourceSetToCreationConfigMap = sourceSetToCreationConfigMap;
        this.inputsMap = new LinkedHashMap();
        this.artifactsMap = new LinkedHashMap();
        this.javaDocArtifactsMap = new LinkedHashMap();
        this.sourceArtifactsMap = new LinkedHashMap();
        this.sampleArtifactsMap = new LinkedHashMap();
    }

    public final void registerSourceSetArtifacts(@NotNull KotlinSourceSet sourceSet2) {
        ArtifactCollectionsInputs artifactCollectionsInputs;
        Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
        if (this.inputsMap.containsKey(sourceSet2)) {
            return;
        }
        KmpComponentCreationConfig kmpComponentCreationConfig = (KmpComponentCreationConfig)((Map)this.sourceSetToCreationConfigMap.getValue()).get(sourceSet2);
        if (kmpComponentCreationConfig == null) {
            throw new IllegalArgumentException("Unable to find a component attached to sourceSet " + sourceSet2.getName());
        }
        KmpComponentCreationConfig component2 = kmpComponentCreationConfig;
        AndroidArtifacts.ConsumedConfigType configType = AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH;
        Map<KotlinSourceSet, ArtifactCollectionsInputs> $this$getOrPut$iv = this.inputsMap;
        boolean $i$f$getOrPut = false;
        ArtifactCollectionsInputs value$iv = $this$getOrPut$iv.get(sourceSet2);
        if (value$iv == null) {
            boolean bl = false;
            VariantDependencies variantDependencies2 = component2.getVariantDependencies();
            String string = this.project.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            ArtifactCollectionsInputs answer$iv = new ArtifactCollectionsInputsImpl(variantDependencies2, string, component2.getName(), ArtifactCollectionsInputs.RuntimeType.FULL);
            $this$getOrPut$iv.put(sourceSet2, answer$iv);
            artifactCollectionsInputs = answer$iv;
        } else {
            artifactCollectionsInputs = value$iv;
        }
        ArtifactCollectionsInputs inputs = artifactCollectionsInputs;
        this.artifactsMap.computeIfAbsent(sourceSet2, new Function(inputs, configType){
            final /* synthetic */ ArtifactCollectionsInputs $inputs;
            final /* synthetic */ AndroidArtifacts.ConsumedConfigType $configType;
            {
                this.$inputs = $inputs;
                this.$configType = $configType;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<VariantKey, ResolvedArtifact> apply(@NotNull KotlinSourceSet it) {
                void $this$associateByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$associateBy$iv = ArtifactCollectionsInputs.getAllArtifacts$default(this.$inputs, this.$configType, null, false, 6, null);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it2;
                    ResolvedArtifact resolvedArtifact = (ResolvedArtifact)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(ArtifactUtils.toKey(it2.getVariant()), element$iv$iv);
                }
                return destination$iv$iv;
            }
        });
        this.javaDocArtifactsMap.computeIfAbsent(sourceSet2, new Function(component2, configType){
            final /* synthetic */ KmpComponentCreationConfig $component;
            final /* synthetic */ AndroidArtifacts.ConsumedConfigType $configType;
            {
                this.$component = $component;
                this.$configType = $configType;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<ComponentIdentifier, File> apply(@NotNull KotlinSourceSet it) {
                void $this$associateTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$associate$iv = (Iterable)this.$component.getVariantDependencies().getAdditionalArtifacts(this.$configType, AdditionalArtifactType.JAVADOC);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    ResolvedArtifactResult it2 = (ResolvedArtifactResult)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it2.getVariant().getOwner(), (Object)it2.getFile());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                return destination$iv$iv;
            }
        });
        this.sourceArtifactsMap.computeIfAbsent(sourceSet2, new Function(component2, configType){
            final /* synthetic */ KmpComponentCreationConfig $component;
            final /* synthetic */ AndroidArtifacts.ConsumedConfigType $configType;
            {
                this.$component = $component;
                this.$configType = $configType;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<ComponentIdentifier, File> apply(@NotNull KotlinSourceSet it) {
                void $this$associateTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$associate$iv = (Iterable)this.$component.getVariantDependencies().getAdditionalArtifacts(this.$configType, AdditionalArtifactType.SOURCE);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    ResolvedArtifactResult it2 = (ResolvedArtifactResult)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it2.getVariant().getOwner(), (Object)it2.getFile());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                return destination$iv$iv;
            }
        });
        this.sampleArtifactsMap.computeIfAbsent(sourceSet2, new Function(component2, configType){
            final /* synthetic */ KmpComponentCreationConfig $component;
            final /* synthetic */ AndroidArtifacts.ConsumedConfigType $configType;
            {
                this.$component = $component;
                this.$configType = $configType;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<ComponentIdentifier, File> apply(@NotNull KotlinSourceSet it) {
                void $this$associateTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$associate$iv = (Iterable)this.$component.getVariantDependencies().getAdditionalArtifacts(this.$configType, AdditionalArtifactType.SAMPLE);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    ResolvedArtifactResult it2 = (ResolvedArtifactResult)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it2.getVariant().getOwner(), (Object)it2.getFile());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                return destination$iv$iv;
            }
        });
    }

    private final ArtifactCollectionsInputs getInputs(KotlinSourceSet sourceSet2) {
        ArtifactCollectionsInputs artifactCollectionsInputs = this.inputsMap.get(sourceSet2);
        Intrinsics.checkNotNull((Object)artifactCollectionsInputs);
        return artifactCollectionsInputs;
    }

    private final Map<VariantKey, ResolvedArtifact> getArtifacts(KotlinSourceSet sourceSet2) {
        Map<VariantKey, ResolvedArtifact> map = this.artifactsMap.get(sourceSet2);
        Intrinsics.checkNotNull(map);
        return map;
    }

    private final Map<ComponentIdentifier, File> getJavaDoc(KotlinSourceSet sourceSet2) {
        Map<ComponentIdentifier, File> map = this.javaDocArtifactsMap.get(sourceSet2);
        Intrinsics.checkNotNull(map);
        return map;
    }

    private final Map<ComponentIdentifier, File> getSources(KotlinSourceSet sourceSet2) {
        Map<ComponentIdentifier, File> map = this.sourceArtifactsMap.get(sourceSet2);
        Intrinsics.checkNotNull(map);
        return map;
    }

    private final Map<ComponentIdentifier, File> getSamples(KotlinSourceSet sourceSet2) {
        Map<ComponentIdentifier, File> map = this.sampleArtifactsMap.get(sourceSet2);
        Intrinsics.checkNotNull(map);
        return map;
    }

    @Nullable
    public final Library getLibrary(@NotNull ResolvedVariantResult variant, @NotNull KotlinSourceSet sourceSet2) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
        return FullDependencyGraphBuilderKt.getLibrary(this.getInputs(sourceSet2).getProjectPath(), this.libraryService, variant, CollectionsKt.emptyList(), this.getArtifacts(sourceSet2), this.getJavaDoc(sourceSet2), this.getSources(sourceSet2), this.getSamples(sourceSet2));
    }
}

