/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsLevel;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;

public interface DiagnosticsHandler {
    default public void error(Diagnostic diagnostic) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            System.err.print("Error in " + diagnostic.getOrigin());
            if (diagnostic.getPosition() != Position.UNKNOWN) {
                System.err.print(" at " + diagnostic.getPosition().getDescription());
            }
            System.err.println(":");
        } else {
            System.err.print("Error: ");
        }
        System.err.println(diagnostic.getDiagnosticMessage());
    }

    default public void warning(Diagnostic diagnostic) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            System.err.print("Warning in " + diagnostic.getOrigin() + ":\n  ");
        } else {
            System.err.print("Warning: ");
        }
        System.err.println(diagnostic.getDiagnosticMessage());
    }

    default public void info(Diagnostic diagnostic) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            System.out.print("In " + diagnostic.getOrigin() + ":\n  ");
        }
        System.out.println(diagnostic.getDiagnosticMessage());
    }

    default public DiagnosticsLevel modifyDiagnosticsLevel(DiagnosticsLevel diagnosticsLevel, Diagnostic diagnostic) {
        return diagnosticsLevel;
    }
}

