/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.preprocessors;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipEntrySource;
import com.android.tools.build.bundletool.io.ZipEntrySourceFactory;
import com.android.tools.build.bundletool.io.ZipReader;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.CompressionLevel;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.preprocessors.ModuleCompressionManager;
import com.android.tools.build.bundletool.validation.BundleConfigValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.ZipArchive;

public final class AppBundleRecompressor {
    private static final long LARGE_ENTRY_SIZE_THRESHOLD_BYTES = SystemEnvironmentProvider.DEFAULT_PROVIDER.getProperty("bundletool.compression.newthread.entrysize").map(Long::parseLong).orElse(100000L);
    private final ListeningExecutorService executor;
    private final ModuleCompressionManager moduleCompressionManager;

    public AppBundleRecompressor(ExecutorService executor) {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.moduleCompressionManager = new ModuleCompressionManager();
    }

    public void recompressAppBundle(File inputFile, File outputFile) {
        try (ZipReader zipReader = ZipReader.createFromFile(inputFile.toPath());
             ZipArchive newBundle = new ZipArchive(outputFile);
             TempDirectory tempDirectory = new TempDirectory(this.getClass().getSimpleName());){
            ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(zipReader, tempDirectory);
            ArrayList<ListenableFuture> sources = new ArrayList<ListenableFuture>();
            Config.BundleConfig bundleConfig = AppBundleRecompressor.extractBundleConfig(zipReader);
            ImmutableSet<String> uncompressedAssetsModules = this.extractModulesWithUncompressedAssets(zipReader, bundleConfig);
            CompressionManager compressionManager = new CompressionManager(bundleConfig, uncompressedAssetsModules);
            for (Entry entry : zipReader.getEntries().values()) {
                CompressionLevel compressionLevel = compressionManager.getCompressionLevel(entry);
                if (compressionLevel.equals((Object)CompressionLevel.SAME_AS_SOURCE) || compressionLevel.equals((Object)CompressionLevel.NO_COMPRESSION) || entry.getUncompressedSize() < LARGE_ENTRY_SIZE_THRESHOLD_BYTES) {
                    sources.add(Futures.immediateFuture((Object)sourceFactory.create(entry, compressionLevel)));
                    continue;
                }
                sources.add(this.executor.submit(() -> sourceFactory.create(entry, compressionLevel)));
            }
            for (ListenableFuture sourceFuture : Futures.inCompletionOrder(sources)) {
                ZipEntrySource source = (ZipEntrySource)Futures.getUnchecked((Future)sourceFuture);
                if (source.getCompressionLevel().isCompressed() && source.getCompressedSize() >= source.getUncompressedSize()) {
                    newBundle.add(sourceFactory.create(source.getEntry(), CompressionLevel.NO_COMPRESSION));
                    continue;
                }
                newBundle.add(source);
            }
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Config.BundleConfig extractBundleConfig(ZipReader zipReader) {
        if (!zipReader.getEntry("BundleConfig.pb").isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("The archive doesn't seem to be an App Bundle, it is missing required file '%s'.", "BundleConfig.pb").build();
        }
        try (InputStream inputStream = zipReader.getUncompressedPayload("BundleConfig.pb");){
            Config.BundleConfig bundleConfig = Config.BundleConfig.parseFrom(inputStream, ExtensionRegistryLite.getEmptyRegistry());
            new BundleConfigValidator().validateCompression(bundleConfig.getCompression());
            Config.BundleConfig bundleConfig2 = bundleConfig;
            return bundleConfig2;
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    private ImmutableSet<String> extractModulesWithUncompressedAssets(ZipReader zipReader, Config.BundleConfig config) {
        return (ImmutableSet)AppBundleRecompressor.getAllManifestsByModuleName(zipReader).entrySet().stream().filter(entry -> {
            AndroidManifest manifest = (AndroidManifest)entry.getValue();
            return this.moduleCompressionManager.shouldForceUncompressAssets(config, manifest);
        }).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableMap<String, AndroidManifest> getAllManifestsByModuleName(ZipReader zipReader) {
        ZipPath manifestSuffixPath = ZipPath.create("manifest/AndroidManifest.xml");
        return (ImmutableMap)zipReader.getEntries().keySet().stream().map(ZipPath::create).filter(zipPath -> zipPath.getNameCount() == 3 && zipPath.endsWith(manifestSuffixPath)).collect(ImmutableMap.toImmutableMap(zipPath -> zipPath.getName(0).toString(), zipPath -> AppBundleRecompressor.parseAndroidManifest(zipReader, zipPath)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AndroidManifest parseAndroidManifest(ZipReader zipReader, ZipPath path) {
        try (InputStream inputStream = zipReader.getUncompressedPayload(path.toString());){
            AndroidManifest androidManifest = AndroidManifest.create(Resources.XmlNode.parseFrom((InputStream)inputStream, (ExtensionRegistryLite)ExtensionRegistryLite.getEmptyRegistry()));
            return androidManifest;
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    private static class CompressionManager {
        private static final ZipPath ASSETS_DIRECTORY = ZipPath.create("assets");
        private final ImmutableList<PathMatcher> uncompressedPathMatchers;
        private final ImmutableSet<String> uncompressedAssetsModuleNames;

        CompressionManager(Config.BundleConfig bundleConfig, ImmutableSet<String> uncompressedAssetsModuleNames) {
            this.uncompressedPathMatchers = (ImmutableList)bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList());
            this.uncompressedAssetsModuleNames = uncompressedAssetsModuleNames;
        }

        CompressionLevel getCompressionLevel(Entry entry) {
            ZipPath bundleEntryPath = ZipPath.create(entry.getName());
            Optional<ZipPath> pathInModule = CompressionManager.toPathInModule(bundleEntryPath);
            if (!pathInModule.isPresent()) {
                return CompressionLevel.SAME_AS_SOURCE;
            }
            String moduleName = bundleEntryPath.getName(0).toString();
            if (pathInModule.get().startsWith(ASSETS_DIRECTORY) && this.uncompressedAssetsModuleNames.contains((Object)moduleName)) {
                return CompressionLevel.NO_COMPRESSION;
            }
            ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(pathInModule.get());
            if (ApkSerializerHelper.requiresAapt2Conversion(pathInApk)) {
                return CompressionLevel.NO_COMPRESSION;
            }
            if (this.uncompressedPathMatchers.stream().anyMatch(matcher -> matcher.matches(pathInApk.toString()))) {
                return CompressionLevel.SAME_AS_SOURCE;
            }
            return CompressionLevel.DEFAULT_COMPRESSION;
        }

        private static Optional<ZipPath> toPathInModule(ZipPath pathInBundle) {
            if (pathInBundle.getNameCount() <= 1 || pathInBundle.startsWith(AppBundle.METADATA_DIRECTORY)) {
                return Optional.empty();
            }
            return Optional.of(pathInBundle.subpath(1, pathInBundle.getNameCount()));
        }
    }
}

