/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.AutoValue_TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectorySegment;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.Immutable;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.IntStream;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class TargetedDirectory {
    public abstract ImmutableList<TargetedDirectorySegment> getPathSegments();

    public abstract ZipPath originalPath();

    public TargetedDirectorySegment getLastSegment() {
        return (TargetedDirectorySegment)Iterables.getLast(this.getPathSegments());
    }

    public String getPathBaseName() {
        return this.getSubPathBaseName(this.getPathSegments().size() - 1);
    }

    public String getSubPathBaseName(int maxIndex) {
        return this.originalPath().subpath(0, maxIndex + 1).resolveSibling(((TargetedDirectorySegment)this.getPathSegments().get(maxIndex)).getName()).toString();
    }

    public String getSubPathBaseName(TargetingDimension dimension) {
        Optional<Integer> targetedSegmentIndex = this.getTargetedPathSegmentIndex(dimension);
        return targetedSegmentIndex.isPresent() ? this.getSubPathBaseName(targetedSegmentIndex.get()) : this.getPathBaseName();
    }

    public Optional<Targeting.AssetsDirectoryTargeting> getTargeting(TargetingDimension dimension) {
        return (Optional)this.getPathSegments().stream().filter(segment -> segment.getTargetingDimension().equals(Optional.of(dimension))).map(segment -> segment.getTargeting()).collect(MoreCollectors.toOptional());
    }

    public TargetedDirectory removeTargeting(TargetingDimension dimension) {
        ImmutableList newSegments = (ImmutableList)this.getPathSegments().stream().map(segment -> segment.removeTargeting(dimension)).collect(ImmutableList.toImmutableList());
        if (this.getPathSegments().equals((Object)newSegments)) {
            return this;
        }
        return TargetedDirectory.create((ImmutableList<TargetedDirectorySegment>)newSegments, this.originalPath());
    }

    public static TargetedDirectory parse(ZipPath directoryPath) {
        Preconditions.checkArgument((directoryPath.getNameCount() > 0 ? 1 : 0) != 0, (Object)"Empty paths are not supported.");
        ImmutableList segments = (ImmutableList)directoryPath.getNames().stream().map(TargetedDirectorySegment::parse).collect(ImmutableList.toImmutableList());
        TargetedDirectory.checkNoDuplicateDimensions((ImmutableList<TargetedDirectorySegment>)segments, directoryPath);
        return TargetedDirectory.create((ImmutableList<TargetedDirectorySegment>)segments, directoryPath);
    }

    public ZipPath toZipPath() {
        ImmutableList pathSegments = (ImmutableList)this.getPathSegments().stream().map(TargetedDirectorySegment::toPathSegment).collect(ImmutableList.toImmutableList());
        return ZipPath.create((ImmutableList<String>)pathSegments);
    }

    private Optional<Integer> getTargetedPathSegmentIndex(TargetingDimension dimension) {
        return (Optional)IntStream.range(0, this.getPathSegments().size()).filter(idx -> ((TargetedDirectorySegment)this.getPathSegments().get(idx)).getTargetingDimension().equals(Optional.of(dimension))).boxed().collect(MoreCollectors.toOptional());
    }

    private static void checkNoDuplicateDimensions(ImmutableList<TargetedDirectorySegment> directorySegments, ZipPath directoryPath) {
        HashSet<TargetingDimension> coveredDimensions = new HashSet<TargetingDimension>();
        for (TargetedDirectorySegment targetedDirectorySegment : directorySegments) {
            if (!targetedDirectorySegment.getTargetingDimension().isPresent()) continue;
            TargetingDimension lastSegmentDimension = targetedDirectorySegment.getTargetingDimension().get();
            if (coveredDimensions.contains((Object)lastSegmentDimension)) {
                throw InvalidBundleException.builder().withUserMessage("Duplicate targeting dimension '%s' on path '%s'.", new Object[]{lastSegmentDimension, directoryPath}).build();
            }
            coveredDimensions.add(lastSegmentDimension);
        }
    }

    private static TargetedDirectory create(ImmutableList<TargetedDirectorySegment> segments, ZipPath originalPath) {
        return new AutoValue_TargetedDirectory(segments, originalPath);
    }
}

