/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.BuildApksManagerComponent;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.ApkDescriptionHelper;
import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ApkSigner;
import com.android.tools.build.bundletool.io.ConcurrencyUtils;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipEntrySource;
import com.android.tools.build.bundletool.io.ZipEntrySourceFactory;
import com.android.tools.build.bundletool.io.ZipReader;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.CompressionLevel;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import shadow.bundletool.com.android.zipflinger.BytesSource;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.ZipArchive;

public final class ZipFlingerApkSerializer
extends ApkSerializer {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    private final ZipReader bundleZipReader;
    private final Config.BundleConfig bundleConfig;
    private final ApkSigner apkSigner;
    private final Aapt2Command aapt2;
    private final Version bundletoolVersion;
    private final boolean enableSparseEncoding;
    private final ListeningExecutorService executorService;
    private final boolean useBundleCompression;

    @Inject
    ZipFlingerApkSerializer(Optional<ApkListener> apkListener, @BuildApksModule.VerboseLogs boolean verbose, ZipReader bundleZipReader, Config.BundleConfig bundleConfig, Aapt2Command aapt2, Version bundletoolVersion, ApkSigner apkSigner, @BuildApksManagerComponent.UseBundleCompression boolean useBundleCompression, ListeningExecutorService executorService) {
        super(apkListener, verbose);
        this.bundleZipReader = bundleZipReader;
        this.bundleConfig = bundleConfig;
        this.aapt2 = aapt2;
        this.bundletoolVersion = bundletoolVersion;
        this.apkSigner = apkSigner;
        this.useBundleCompression = useBundleCompression;
        this.enableSparseEncoding = bundleConfig.getOptimizations().getResourceOptimizations().getSparseEncoding().equals((Object)Config.ResourceOptimizations.SparseEncoding.ENFORCED);
        this.executorService = executorService;
    }

    @Override
    public ImmutableMap<ZipPath, Commands.ApkDescription> serialize(Path outputDirectory, ImmutableMap<ZipPath, ModuleSplit> splitsByRelativePath) {
        Map serializedSplits = Maps.transformEntries(splitsByRelativePath, (relativePath, split) -> this.executorService.submit(() -> {
            this.writeToZipFile((ModuleSplit)split, outputDirectory.resolve(relativePath.toString()));
            Commands.ApkDescription apkDescription = ApkDescriptionHelper.createApkDescription(relativePath, split);
            this.notifyApkSerialized(apkDescription, split.getSplitType());
            return apkDescription;
        }));
        return ConcurrencyUtils.waitForAll(serializedSplits);
    }

    public Path writeToZipFile(ModuleSplit split, Path outputPath) {
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());){
            this.writeToZipFile(split, outputPath, tempDir);
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
        return outputPath;
    }

    private void writeToZipFile(ModuleSplit split, Path outputPath, TempDirectory tempDir) throws IOException {
        FilePreconditions.checkFileDoesNotExist(outputPath);
        FileUtils.createParentDirectories(outputPath);
        split = this.apkSigner.signEmbeddedApks(split);
        Path partialProtoApk = tempDir.getPath().resolve("proto.apk");
        this.writeProtoApk(split, partialProtoApk, tempDir);
        Path binaryApkPath = tempDir.getPath().resolve("binary.apk");
        if (this.enableSparseEncoding && split.getResourceTable().isPresent()) {
            Path interimApk = tempDir.getPath().resolve("interim.apk");
            this.aapt2.convertApkProtoToBinary(partialProtoApk, interimApk);
            this.aapt2.optimizeToSparseResourceTables(interimApk, binaryApkPath);
        } else {
            this.aapt2.convertApkProtoToBinary(partialProtoApk, binaryApkPath);
        }
        Preconditions.checkState((boolean)Files.exists(binaryApkPath, new LinkOption[0]), (Object)"No APK created by aapt2 convert command.");
        try (ZipArchive apkWriter = new ZipArchive(outputPath);
             ZipReader aapt2ApkReader = ZipReader.createFromFile(binaryApkPath);){
            ImmutableMap moduleEntriesByName = (ImmutableMap)split.getEntries().stream().collect(ImmutableMap.toImmutableMap(entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath()), entry -> entry, (a5, b5) -> b5));
            ImmutableSortedSet sortedEntryNames = (ImmutableSortedSet)Stream.concat(aapt2ApkReader.getEntries().keySet().stream().map(ZipPath::create), moduleEntriesByName.keySet().stream()).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
            ApkEntrySerializer apkEntrySerializer = new ApkEntrySerializer(apkWriter, aapt2ApkReader, split, tempDir);
            for (ZipPath pathInApk : sortedEntryNames) {
                Optional<Entry> aapt2Entry = aapt2ApkReader.getEntry(pathInApk.toString());
                if (aapt2Entry.isPresent()) {
                    apkEntrySerializer.addAapt2Entry(pathInApk, aapt2Entry.get());
                    continue;
                }
                ModuleEntry moduleEntry = (ModuleEntry)Preconditions.checkNotNull((Object)moduleEntriesByName.get((Object)pathInApk));
                apkEntrySerializer.addRegularEntry(pathInApk, moduleEntry);
            }
        }
        this.apkSigner.signApk(outputPath, split);
    }

    private void writeProtoApk(ModuleSplit split, Path protoApkPath, TempDirectory tempDir) throws IOException {
        try (ZipArchive apkWriter = new ZipArchive(protoApkPath);){
            apkWriter.add(new BytesSource(split.getAndroidManifest().getManifestRoot().getProto().toByteArray(), "AndroidManifest.xml", (int)CompressionLevel.NO_COMPRESSION.getValue()));
            if (split.getResourceTable().isPresent()) {
                BytesSource bytesSource = new BytesSource(split.getResourceTable().get().toByteArray(), BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath().toString(), (int)CompressionLevel.NO_COMPRESSION.getValue());
                bytesSource.align(4L);
                apkWriter.add(bytesSource);
            }
            ImmutableMap<String, Entry> bundleEntriesByName = this.bundleZipReader.getEntries();
            ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(this.bundleZipReader, tempDir);
            for (ModuleEntry moduleEntry : split.getEntries()) {
                ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(moduleEntry.getPath());
                if (!ApkSerializerHelper.requiresAapt2Conversion(pathInApk)) continue;
                if (moduleEntry.getBundleLocation().isPresent()) {
                    ZipPath pathInBundle = moduleEntry.getBundleLocation().get().entryPathInBundle();
                    Entry entry = (Entry)bundleEntriesByName.get(pathInBundle.toString());
                    Preconditions.checkNotNull((Object)entry, (String)"Could not find entry '%s'.", (Object)pathInBundle);
                    apkWriter.add(sourceFactory.create(entry, pathInApk, CompressionLevel.NO_COMPRESSION));
                    continue;
                }
                apkWriter.add(new BytesSource(moduleEntry.getContent().read(), pathInApk.toString(), (int)CompressionLevel.NO_COMPRESSION.getValue()));
            }
        }
    }

    private static long getEntryAlignment(ZipPath zipPath, boolean compressed) {
        if (compressed) {
            return 0L;
        }
        return zipPath.toString().endsWith(NATIVE_LIBRARIES_SUFFIX) ? 4096L : 4L;
    }

    private class CompressionManager {
        private final boolean uncompressNativeLibs;
        private final ImmutableSet<ZipPath> forceUncompressedEntries;
        private final ImmutableList<PathMatcher> uncompressedPathMatchers;

        CompressionManager(ModuleSplit split, Config.BundleConfig bundleConfig) {
            this.uncompressNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true) == false;
            this.forceUncompressedEntries = (ImmutableSet)split.getEntries().stream().filter(ModuleEntry::getForceUncompressed).map(entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath())).collect(ImmutableSet.toImmutableSet());
            this.uncompressedPathMatchers = (ImmutableList)bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList());
        }

        public boolean mayCompress(ZipPath path) {
            String pathString = path.toString();
            if (pathString.equals("resources.arsc")) {
                return false;
            }
            if (pathString.equals("AndroidManifest.xml")) {
                return true;
            }
            if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(pathString))) {
                return false;
            }
            if (this.forceUncompressedEntries.contains((Object)path)) {
                return false;
            }
            if (!VersionGuardedFeature.NO_DEFAULT_UNCOMPRESS_EXTENSIONS.enabledForVersion(ZipFlingerApkSerializer.this.bundletoolVersion) && ApkSerializerHelper.NO_COMPRESSION_EXTENSIONS.contains((Object)FileUtils.getFileExtension(path))) {
                return false;
            }
            return !this.uncompressNativeLibs || !NATIVE_LIBRARIES_PATTERN.matcher(pathString).matches();
        }
    }

    private final class ApkEntrySerializer {
        private final ZipArchive apkWriter;
        private final ZipReader aapt2Apk;
        private final TempDirectory tempDir;
        private final CompressionManager compressionManager;
        private final ImmutableMap<String, Entry> bundleEntries;

        ApkEntrySerializer(ZipArchive apkWriter, ZipReader aapt2Apk, ModuleSplit moduleSplit, TempDirectory tempDir) {
            this.apkWriter = apkWriter;
            this.aapt2Apk = aapt2Apk;
            this.tempDir = tempDir;
            this.compressionManager = new CompressionManager(moduleSplit, ZipFlingerApkSerializer.this.bundleConfig);
            this.bundleEntries = ZipFlingerApkSerializer.this.bundleZipReader.getEntries();
        }

        void addRegularEntry(ZipPath pathInApk, ModuleEntry moduleEntry) throws IOException {
            ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(ZipFlingerApkSerializer.this.bundleZipReader, this.tempDir);
            boolean mayCompress = this.compressionManager.mayCompress(pathInApk);
            if (moduleEntry.getBundleLocation().isPresent()) {
                ZipPath pathInBundle = moduleEntry.getBundleLocation().get().entryPathInBundle();
                Entry entry = (Entry)this.bundleEntries.get((Object)pathInBundle.toString());
                Preconditions.checkNotNull((Object)entry, (String)"Could not find entry '%s'.", (Object)pathInBundle);
                CompressionLevel compressionLevel = mayCompress ? (ZipFlingerApkSerializer.this.useBundleCompression && entry.isCompressed() ? CompressionLevel.SAME_AS_SOURCE : CompressionLevel.DEFAULT_COMPRESSION) : CompressionLevel.NO_COMPRESSION;
                ZipEntrySource entrySource = sourceFactory.create(entry, pathInApk, compressionLevel).setAlignment(ZipFlingerApkSerializer.getEntryAlignment(pathInApk, mayCompress));
                if (compressionLevel.isCompressed() && entrySource.getCompressedSize() >= entrySource.getUncompressedSize()) {
                    entrySource = sourceFactory.create(entry, pathInApk, CompressionLevel.NO_COMPRESSION).setAlignment(ZipFlingerApkSerializer.getEntryAlignment(pathInApk, false));
                }
                this.apkWriter.add(entrySource);
            } else {
                byte[] uncompressedContent = moduleEntry.getContent().read();
                BytesSource bytesSource = new BytesSource(uncompressedContent, pathInApk.toString(), (int)(mayCompress ? CompressionLevel.DEFAULT_COMPRESSION.getValue() : CompressionLevel.NO_COMPRESSION.getValue()));
                bytesSource.align(ZipFlingerApkSerializer.getEntryAlignment(pathInApk, mayCompress));
                if (mayCompress && bytesSource.getCompressedSize() >= bytesSource.getUncompressedSize()) {
                    bytesSource = new BytesSource(uncompressedContent, pathInApk.toString(), (int)CompressionLevel.NO_COMPRESSION.getValue());
                    bytesSource.align(ZipFlingerApkSerializer.getEntryAlignment(pathInApk, false));
                }
                this.apkWriter.add(bytesSource);
            }
        }

        void addAapt2Entry(ZipPath pathInApk, Entry entry) throws IOException {
            ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(this.aapt2Apk, this.tempDir);
            boolean mayCompress = this.compressionManager.mayCompress(pathInApk);
            CompressionLevel compressionLevel = mayCompress ? CompressionLevel.BEST_COMPRESSION : CompressionLevel.NO_COMPRESSION;
            ZipEntrySource entrySource = sourceFactory.create(entry, pathInApk, compressionLevel).setAlignment(ZipFlingerApkSerializer.getEntryAlignment(pathInApk, mayCompress));
            if (!compressionLevel.equals((Object)CompressionLevel.NO_COMPRESSION) && entrySource.getCompressedSize() + entrySource.getCompressedSize() / 10L > entrySource.getUncompressedSize()) {
                entrySource = sourceFactory.create(entry, pathInApk, CompressionLevel.NO_COMPRESSION).setAlignment(ZipFlingerApkSerializer.getEntryAlignment(pathInApk, false));
            }
            this.apkWriter.add(entrySource);
        }
    }
}

