/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import shadow.bundletool.com.android.zipflinger.Compressor;
import shadow.bundletool.com.android.zipflinger.Crc32;
import shadow.bundletool.com.android.zipflinger.NoCopyByteArrayOutputStream;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.ZipWriter;

public class BytesSource
extends Source {
    private ByteBuffer zipEntryPayload;

    protected BytesSource(String name) {
        super(name);
    }

    public BytesSource(byte[] bytes, String name, int compressionLevel) throws IOException {
        super(name);
        this.build(bytes, bytes.length, compressionLevel);
    }

    public BytesSource(Path file, String name, int compressionLevel) throws IOException {
        super(name);
        byte[] bytes = Files.readAllBytes(file);
        this.build(bytes, bytes.length, compressionLevel);
    }

    @Deprecated
    public BytesSource(File file, String name, int compressionLevel) throws IOException {
        this(file.toPath(), name, compressionLevel);
    }

    public BytesSource(InputStream stream, String name, int compressionLevel) throws IOException {
        super(name);
        try (NoCopyByteArrayOutputStream ncbos = new NoCopyByteArrayOutputStream(16000);){
            int bytesRead;
            byte[] tmpBuffer = new byte[16000];
            while ((bytesRead = stream.read(tmpBuffer)) != -1) {
                ncbos.write(tmpBuffer, 0, bytesRead);
            }
            stream.close();
            this.build(ncbos.buf(), ncbos.getCount(), compressionLevel);
        }
    }

    protected void build(byte[] bytes, int size, int compressionLevel) throws IOException {
        this.crc = Crc32.crc32(bytes, 0, size);
        this.uncompressedSize = size;
        if (compressionLevel == 0) {
            this.zipEntryPayload = ByteBuffer.wrap(bytes, 0, size);
            this.compressedSize = this.uncompressedSize;
            this.compressionFlag = 0;
        } else {
            this.zipEntryPayload = Compressor.deflate(bytes, 0, size, compressionLevel);
            this.compressedSize = this.zipEntryPayload.limit();
            this.compressionFlag = (short)8;
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.zipEntryPayload);
    }
}

