/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.android.tools.build.bundletool.validation.AutoValue_TextureCompressionFormatParityValidator_SupportedTextureCompressionFormats;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import java.util.List;
import java.util.Optional;

public class TextureCompressionFormatParityValidator
extends SubValidator {
    @Override
    public void validateBundle(AppBundle bundle) {
        Config.BundleConfig bundleConfig = bundle.getBundleConfig();
        Config.Optimizations optimizations = bundleConfig.getOptimizations();
        List<Config.SplitDimension> splitDimensions = optimizations.getSplitsConfig().getSplitDimensionList();
        Optional tcfDefaultSuffix = (Optional)splitDimensions.stream().filter(dimension -> dimension.getValue().equals((Object)Config.SplitDimension.Value.TEXTURE_COMPRESSION_FORMAT)).map(dimension -> dimension.getSuffixStripping().getDefaultSuffix()).collect(MoreCollectors.toOptional());
        if (tcfDefaultSuffix.isPresent()) {
            Optional<Object> defaultTextureCompressionFormat = Optional.ofNullable(TextureCompressionUtils.TEXTURE_TO_TARGETING.get(tcfDefaultSuffix.get()));
            TextureCompressionFormatParityValidator.validateFormatSupportedByAllModules(bundle, defaultTextureCompressionFormat);
        }
    }

    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        TextureCompressionFormatParityValidator.validateAllModulesSupportSameFormats(modules);
    }

    private static void validateFormatSupportedByAllModules(AppBundle bundle, Optional<Targeting.TextureCompressionFormatTargeting> defaultTextureCompressionFormat) {
        bundle.getModules().values().forEach(module -> {
            SupportedTextureCompressionFormats moduleTextureCompressionFormats = TextureCompressionFormatParityValidator.getSupportedTextureCompressionFormats(module);
            if (moduleTextureCompressionFormats.getFormats().isEmpty()) {
                return;
            }
            if (!defaultTextureCompressionFormat.isPresent()) {
                if (!moduleTextureCompressionFormats.getHasFallback()) {
                    throw InvalidBundleException.builder().withUserMessage("When a standalone or universal APK is built, the fallback texture folders (folders without #tcf suffixes) will be used, but module '%s' has no such folders. Instead, it has folder(s) targeted for formats %s. Either add missing folders or change the configuration for the TEXTURE_COMPRESSION_FORMAT optimization to specify a default suffix corresponding to the format to use in the standalone and universal APKs.", module.getName(), moduleTextureCompressionFormats).build();
                }
            } else {
                Targeting.TextureCompressionFormat.TextureCompressionFormatAlias defaultTextureCompressionFormatAlias = ((Targeting.TextureCompressionFormatTargeting)defaultTextureCompressionFormat.get()).getValue(0).getAlias();
                if (!moduleTextureCompressionFormats.getFormats().contains((Object)defaultTextureCompressionFormatAlias)) {
                    throw InvalidBundleException.builder().withUserMessage("When a standalone or universal APK is built, the texture folders for format '%s' will be used, but module '%s' has no such folders. Instead, it has folder(s) targeted for formats %s. Either add missing folders or change the configuration for the TEXTURE_COMPRESSION_FORMAT optimization to specify a default suffix corresponding to the format to use in the standalone and universal APKs.", new Object[]{defaultTextureCompressionFormatAlias, module.getName(), moduleTextureCompressionFormats}).build();
                }
            }
        });
    }

    private static void validateAllModulesSupportSameFormats(ImmutableList<BundleModule> modules) {
        BundleModule referentialModule = null;
        Object referentialTextureCompressionFormats = null;
        for (BundleModule module : modules) {
            SupportedTextureCompressionFormats moduleTextureCompressionFormats = TextureCompressionFormatParityValidator.getSupportedTextureCompressionFormats(module);
            if (moduleTextureCompressionFormats.getFormats().isEmpty()) continue;
            if (referentialTextureCompressionFormats == null) {
                referentialModule = module;
                referentialTextureCompressionFormats = moduleTextureCompressionFormats;
                continue;
            }
            if (referentialTextureCompressionFormats.equals(moduleTextureCompressionFormats)) continue;
            throw InvalidBundleException.builder().withUserMessage("All modules with targeted textures must have the same set of texture formats, but module '%s' has formats %s and module '%s' has formats %s.", referentialModule.getName(), referentialTextureCompressionFormats, module.getName(), moduleTextureCompressionFormats).build();
        }
    }

    private static SupportedTextureCompressionFormats getSupportedTextureCompressionFormats(BundleModule module) {
        ImmutableSet<TargetedDirectory> targetedDirectories = TargetingUtils.extractAssetsTargetedDirectories(module);
        ImmutableSet<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> formats = TargetingUtils.extractTextureCompressionFormats(targetedDirectories);
        boolean hasFallback = targetedDirectories.stream().anyMatch(directory -> {
            Optional<Targeting.AssetsDirectoryTargeting> targeting = directory.getTargeting(TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
            if (targeting.isPresent()) {
                TargetedDirectory siblingFallbackDirectory = directory.removeTargeting(TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
                return module.findEntriesUnderPath(siblingFallbackDirectory.toZipPath()).findAny().isPresent();
            }
            return false;
        });
        return SupportedTextureCompressionFormats.create(formats, hasFallback);
    }

    @AutoValue
    public static abstract class SupportedTextureCompressionFormats {
        public static SupportedTextureCompressionFormats create(ImmutableSet<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> formats, boolean hasFallback) {
            return new AutoValue_TextureCompressionFormatParityValidator_SupportedTextureCompressionFormats(formats, hasFallback);
        }

        public abstract ImmutableSet<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> getFormats();

        public abstract boolean getHasFallback();

        public final String toString() {
            return this.getFormats().toString() + (this.getHasFallback() ? " (with fallback directories)" : " (without fallback directories)");
        }
    }
}

