/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.transparency.AutoValue_ApkSignatureVerifier_Result;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import shadow.bundletool.com.android.apksig.ApkVerifier;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;

final class ApkSignatureVerifier {
    static Result verify(ImmutableList<Path> deviceSpecificApks) {
        Preconditions.checkArgument((!deviceSpecificApks.isEmpty() ? 1 : 0) != 0, (Object)"Expected non-empty list of device-specific APKs.");
        Optional<Object> apkSigningKeyCertificate = Optional.empty();
        try {
            for (Path apkPath : deviceSpecificApks) {
                ApkVerifier.Result apkSignatureVerificationResult = new ApkVerifier.Builder(apkPath.toFile()).build().verify();
                if (!apkSignatureVerificationResult.isVerified()) {
                    return Result.failure("APK signature invalid for " + apkPath.getFileName());
                }
                X509Certificate currentCertificate = apkSignatureVerificationResult.getSignerCertificates().get(0);
                if (apkSigningKeyCertificate.isPresent()) {
                    if (((X509Certificate)apkSigningKeyCertificate.get()).equals(currentCertificate)) continue;
                    return Result.failure("APK signature verification failed: the keys used to sign the given set of device specific APKs do not match.");
                }
                apkSigningKeyCertificate = Optional.of(currentCertificate);
            }
        }
        catch (IOException | NoSuchAlgorithmException | ApkFormatException e5) {
            throw CommandExecutionException.builder().withInternalMessage("Exception during APK signature verification.").withCause(e5).build();
        }
        return Result.success(CodeTransparencyCryptoUtils.getCertificateFingerprint((X509Certificate)apkSigningKeyCertificate.get()));
    }

    private ApkSignatureVerifier() {
    }

    @AutoValue
    static abstract class Result {
        Result() {
        }

        abstract Optional<String> apkSigningKeyCertificateFingerprint();

        abstract Optional<String> errorMessage();

        boolean verified() {
            return this.apkSigningKeyCertificateFingerprint().isPresent() && !this.errorMessage().isPresent();
        }

        String getApkSigningKeyCertificateFingerprint() {
            return this.apkSigningKeyCertificateFingerprint().orElse("");
        }

        String getErrorMessage() {
            return this.errorMessage().orElse("");
        }

        static Result success(String apkSigningKeyCertificateFingerprint) {
            return new AutoValue_ApkSignatureVerifier_Result(Optional.of(apkSigningKeyCertificateFingerprint), Optional.empty());
        }

        static Result failure(String errorMessage) {
            return new AutoValue_ApkSignatureVerifier_Result(Optional.empty(), Optional.of(errorMessage));
        }
    }
}

