/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.internal;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.internal.HibernatedAndroidManifestUtils;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.inject.Inject;

public final class HibernatedApksGenerator {
    private static final String HIBERNATED_CLASSES_DEX_PATH = "dex/classes.dex";
    private final TempDirectory globalTempDir;

    @Inject
    HibernatedApksGenerator(TempDirectory globalTempDir) {
        this.globalTempDir = globalTempDir;
    }

    public ModuleSplit generateHibernatedApk(AppBundle appBundle) throws IOException {
        Preconditions.checkNotNull((Object)appBundle);
        if (!appBundle.storeArchiveEnabled()) {
            throw InvalidCommandException.builder().withInternalMessage("Hibernated APK cannot be generated when Store Archive configuration is disabled.").build();
        }
        BundleModule baseModule = appBundle.getBaseModule();
        AndroidManifest hibernatedManifest = HibernatedAndroidManifestUtils.createHibernatedManifest(baseModule.getAndroidManifest());
        Optional<Resources.ResourceTable> hibernatedResourceTable = this.getHibernatedResourceTable(appBundle, baseModule, hibernatedManifest);
        Path hibernatedClassesDexFile = this.getHibernatedClassesDexFile();
        return ModuleSplit.forHibernation(baseModule, hibernatedManifest, hibernatedResourceTable, hibernatedClassesDexFile);
    }

    private Optional<Resources.ResourceTable> getHibernatedResourceTable(AppBundle appBundle, BundleModule bundleModule, AndroidManifest hibernatedManifest) throws IOException {
        if (!bundleModule.getResourceTable().isPresent()) {
            return Optional.empty();
        }
        ImmutableSet<ResourceId> referredResources = new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromManifest(hibernatedManifest);
        Resources.ResourceTable hibernatedResourceTable = ResourcesUtils.filterResourceTable(bundleModule.getResourceTable().get(), entry -> !referredResources.contains((Object)entry.getResourceId()), ResourceTableEntry::getEntry);
        return Optional.of(hibernatedResourceTable);
    }

    private Path getHibernatedClassesDexFile() throws IOException {
        Path hibernatedDexFilePath = Files.createTempFile(this.globalTempDir.getPath(), "classes", ".dex", new FileAttribute[0]);
        try (InputStream inputStream = HibernatedApksGenerator.readHibernatedClassesDexFile();){
            Files.copy(inputStream, hibernatedDexFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        return hibernatedDexFilePath;
    }

    private static InputStream readHibernatedClassesDexFile() {
        return HibernatedApksGenerator.class.getResourceAsStream(HIBERNATED_CLASSES_DEX_PATH);
    }
}

