/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AppBundleModule;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BundleConfigModule;
import com.android.tools.build.bundletool.commands.BundletoolModule;
import com.android.tools.build.bundletool.commands.CommandScoped;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.io.ApkSerializerModule;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.DefaultSigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.optimizations.OptimizationsMerger;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.protobuf.Int32Value;
import dagger.Module;
import dagger.Provides;
import java.io.PrintStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Optional;
import javax.inject.Qualifier;

@Module(includes={BundleConfigModule.class, BundletoolModule.class, AppBundleModule.class, ApkSerializerModule.class})
public final class BuildApksModule {
    @CommandScoped
    @Provides
    @ApkSigningConfigProvider
    static Optional<SigningConfigurationProvider> provideApkSigningConfigurationProvider(BuildApksCommand command, Version version) {
        if (command.getSigningConfigurationProvider().isPresent()) {
            return command.getSigningConfigurationProvider();
        }
        return command.getSigningConfiguration().map(signingConfig -> new DefaultSigningConfigurationProvider((SigningConfiguration)signingConfig, version));
    }

    @CommandScoped
    @Provides
    @StampSigningConfig
    static Optional<SigningConfiguration> provideStampSigningConfiguration(BuildApksCommand command) {
        return command.getSourceStamp().map(SourceStamp::getSigningConfiguration);
    }

    @CommandScoped
    @Provides
    static Optional<SourceStamp> provideStampSource(BuildApksCommand command) {
        return command.getSourceStamp();
    }

    @CommandScoped
    @Provides
    static ListeningExecutorService provideExecutorService(BuildApksCommand command) {
        return command.getExecutorService();
    }

    @CommandScoped
    @Provides
    static Optional<ApkListener> provideApkListener(BuildApksCommand command) {
        return command.getApkListener();
    }

    @CommandScoped
    @Provides
    static Optional<ApkModifier> provideApkModifier(BuildApksCommand command) {
        return command.getApkModifier();
    }

    @CommandScoped
    @Provides
    static ApkOptimizations provideApkOptimizations(Config.BundleConfig bundleConfig, BuildApksCommand command, OptimizationsMerger optimizationsMerger) {
        return optimizationsMerger.mergeWithDefaults(bundleConfig, command.getOptimizationDimensions());
    }

    @CommandScoped
    @Provides
    static BuildApksCommand.ApkBuildMode provideApkBuildMode(BuildApksCommand command) {
        return command.getApkBuildMode();
    }

    @CommandScoped
    @FirstVariantNumber
    @Provides
    static Optional<Integer> provideFirstVariantNumber(BuildApksCommand command) {
        return command.getFirstVariantNumber();
    }

    @CommandScoped
    @Provides
    static Optional<PrintStream> provideOutputPrintStream(BuildApksCommand command) {
        return command.getOutputPrintStream();
    }

    @CommandScoped
    @Provides
    static Optional<Devices.DeviceSpec> provideDeviceSpec(BuildApksCommand command) {
        Optional<Devices.DeviceSpec> deviceSpec = command.getDeviceSpec();
        if (command.getGenerateOnlyForConnectedDevice()) {
            AdbServer adbServer = command.getAdbServer().get();
            adbServer.init(command.getAdbPath().get());
            deviceSpec = Optional.of(new DeviceAnalyzer(adbServer).getDeviceSpec(command.getDeviceId()));
        }
        if (command.getDeviceTier().isPresent()) {
            Preconditions.checkState((boolean)deviceSpec.isPresent(), (Object)"Device tier specified but no device was provided.");
            deviceSpec = deviceSpec.map(spec -> spec.toBuilder().setDeviceTier(Int32Value.of((int)command.getDeviceTier().get())).build());
        }
        return deviceSpec;
    }

    @CommandScoped
    @Provides
    @VerboseLogs
    static boolean provideVerbose(BuildApksCommand command) {
        return command.getVerbose();
    }

    private BuildApksModule() {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StampSigningConfig {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ApkSigningConfigProvider {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ApkSigningConfig {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface VerboseLogs {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FirstVariantNumber {
    }
}

