/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public class DeviceTierParityValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        BundleModule referenceModule = null;
        ImmutableSet<Integer> referenceTiers = null;
        for (BundleModule module : modules) {
            ImmutableSet<Integer> moduleTiers = TargetingUtils.extractDeviceTiers(TargetingUtils.extractAssetsTargetedDirectories(module));
            if (moduleTiers.isEmpty()) continue;
            if (referenceTiers == null) {
                referenceModule = module;
                referenceTiers = moduleTiers;
                continue;
            }
            if (referenceTiers.equals(moduleTiers)) continue;
            throw InvalidBundleException.builder().withUserMessage("All modules with device tier targeting must support the same set of tiers, but module '%s' supports %s and module '%s' supports %s.", referenceModule.getName(), referenceTiers, module.getName(), moduleTiers).build();
        }
    }
}

