/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.targeting.TargetingComparators;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.stream.Stream;

public class MultiAbiMatcher
extends TargetingDimensionMatcher<Targeting.MultiAbiTargeting> {
    public MultiAbiMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
    }

    @Override
    public boolean matchesTargeting(Targeting.MultiAbiTargeting targeting) {
        if (targeting.equals(Targeting.MultiAbiTargeting.getDefaultInstance())) {
            return true;
        }
        ImmutableSet valuesSet = (ImmutableSet)targeting.getValueList().stream().map(MultiAbiMatcher::abiAliases).collect(ImmutableSet.toImmutableSet());
        ImmutableSet<Targeting.Abi.AbiAlias> deviceAbis = this.deviceAbiAliases();
        if (valuesSet.stream().noneMatch(arg_0 -> deviceAbis.containsAll(arg_0))) {
            return false;
        }
        ImmutableSet alternativesSet = (ImmutableSet)targeting.getAlternativesList().stream().map(MultiAbiMatcher::abiAliases).collect(ImmutableSet.toImmutableSet());
        return alternativesSet.stream().noneMatch(alternative -> deviceAbis.containsAll((Collection)alternative) && valuesSet.stream().allMatch(value -> TargetingComparators.MULTI_ABI_ALIAS_COMPARATOR.compare((ImmutableSet<Targeting.Abi.AbiAlias>)alternative, (ImmutableSet<Targeting.Abi.AbiAlias>)value) > 0));
    }

    @Override
    protected void checkDeviceCompatibleInternal(Targeting.MultiAbiTargeting targeting) {
        if (targeting.equals(Targeting.MultiAbiTargeting.getDefaultInstance())) {
            return;
        }
        ImmutableSet valuesAndAlternativesSet = (ImmutableSet)Streams.concat((Stream[])new Stream[]{targeting.getValueList().stream().map(MultiAbiMatcher::abiAliases), targeting.getAlternativesList().stream().map(MultiAbiMatcher::abiAliases)}).collect(ImmutableSet.toImmutableSet());
        ImmutableSet<Targeting.Abi.AbiAlias> deviceAbis = this.deviceAbiAliases();
        if (valuesAndAlternativesSet.stream().noneMatch(arg_0 -> deviceAbis.containsAll(arg_0))) {
            throw IncompatibleDeviceException.builder().withUserMessage("No set of ABI architectures that the app supports is contained in the ABI architecture set of the device. Device ABIs: %s, app ABIs: %s.", deviceAbis, valuesAndAlternativesSet).build();
        }
    }

    @Override
    protected Targeting.MultiAbiTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getMultiAbiTargeting();
    }

    @Override
    protected Targeting.MultiAbiTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return variantTargeting.getMultiAbiTargeting();
    }

    @Override
    protected boolean isDeviceDimensionPresent() {
        return !this.getDeviceSpec().getSupportedAbisList().isEmpty();
    }

    private static ImmutableSet<Targeting.Abi.AbiAlias> abiAliases(Targeting.MultiAbi multiAbi) {
        return (ImmutableSet)multiAbi.getAbiList().stream().map(Targeting.Abi::getAlias).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<Targeting.Abi.AbiAlias> deviceAbiAliases() {
        return (ImmutableSet)this.getDeviceSpec().getSupportedAbisList().stream().map(abi -> AbiName.fromPlatformName(abi).orElseThrow(() -> InvalidCommandException.builder().withInternalMessage("Unrecognized ABI '%s' in device spec.", abi).build()).toProto()).collect(ImmutableSet.toImmutableSet());
    }
}

