/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.commands.AutoValue_CheckTransparencyCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.transparency.CodeTransparencyChecker;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.auto.value.AutoValue;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class CheckTransparencyCommand {
    public static final String COMMAND_NAME = "check-transparency";
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");

    public abstract Path getBundlePath();

    public static Builder builder() {
        return new AutoValue_CheckTransparencyCommand.Builder();
    }

    public static CheckTransparencyCommand fromFlags(ParsedFlags flags) {
        Builder checkTransparencyCommandBuilder = CheckTransparencyCommand.builder().setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags));
        flags.checkNoUnknownFlags();
        return checkTransparencyCommandBuilder.build();
    }

    public void execute() {
        this.validateInputs();
        this.checkTransparency(System.out);
    }

    public void checkTransparency(PrintStream outputStream) {
        try (ZipFile bundleZip = new ZipFile(this.getBundlePath().toFile());){
            AppBundle inputBundle = AppBundle.buildFromZip(bundleZip);
            Optional<ByteSource> transparencyFile = inputBundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "code_transparency.json");
            if (!transparencyFile.isPresent()) {
                throw InvalidBundleException.builder().withUserMessage("Bundle does not include code transparency metadata. Run `add-transparency` command to add code transparency metadata to the bundle.").build();
            }
            TransparencyCheckResult transparencyCheckResult = CodeTransparencyChecker.checkTransparency(inputBundle, transparencyFile.get());
            if (transparencyCheckResult.verified()) {
                outputStream.print("Code transparency verified.");
            } else {
                outputStream.print("Code transparency verification failed.\n" + transparencyCheckResult.getDiffAsString());
            }
        }
        catch (ZipException e4) {
            throw InvalidBundleException.builder().withCause(e4).withUserMessage("The App Bundle is not a valid zip file.").build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException("An error occurred when processing the App Bundle.", e5);
        }
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Verifies code transparency for the given bundle.").build()).build();
    }

    private void validateInputs() {
        FilePreconditions.checkFileHasExtension("AAB file", this.getBundlePath(), ".aab");
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract CheckTransparencyCommand build();
    }
}

