/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.util.ArrayList;
import java.util.Arrays;
import shadow.bundletool.com.android.ddmlib.IShellOutputReceiver;

public class MultiReceiver
implements IShellOutputReceiver {
    private final ArrayList<IShellOutputReceiver> myReceivers;

    public MultiReceiver(IShellOutputReceiver ... receivers) {
        this.myReceivers = new ArrayList<IShellOutputReceiver>(Arrays.asList(receivers));
    }

    @Override
    public void addOutput(byte[] data, int offset, int length) {
        this.updateReceiverList();
        for (IShellOutputReceiver receiver : this.myReceivers) {
            receiver.addOutput(data, offset, length);
        }
    }

    @Override
    public void flush() {
        this.updateReceiverList();
        for (IShellOutputReceiver receiver : this.myReceivers) {
            receiver.flush();
        }
        this.myReceivers.clear();
    }

    @Override
    public boolean isCancelled() {
        this.updateReceiverList();
        return this.myReceivers.isEmpty();
    }

    private void updateReceiverList() {
        this.myReceivers.removeIf(IShellOutputReceiver::isCancelled);
    }
}

