/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.Collection;
import shadow.bundletool.com.android.ddmlib.IShellOutputReceiver;

public abstract class MultiLineReceiver
implements IShellOutputReceiver {
    private boolean mTrimLines = true;
    private String mUnfinishedLine = null;
    private final Collection<String> mArray = new ArrayList<String>();

    public void setTrimLine(boolean trim) {
        this.mTrimLines = trim;
    }

    @Override
    public final void addOutput(byte[] data, int offset, int length) {
        if (!this.isCancelled()) {
            Object s11 = new String(data, offset, length, Charsets.UTF_8);
            if (this.mUnfinishedLine != null) {
                s11 = this.mUnfinishedLine + (String)s11;
                this.mUnfinishedLine = null;
            }
            this.mArray.clear();
            int start = 0;
            while (true) {
                int index;
                if ((index = ((String)s11).indexOf(10, start)) == -1) break;
                int newlineLength = 1;
                if (index > 0 && ((String)s11).charAt(index - 1) == '\r') {
                    --index;
                    newlineLength = 2;
                }
                String line = ((String)s11).substring(start, index);
                if (this.mTrimLines) {
                    line = line.trim();
                }
                this.mArray.add(line);
                start = index + newlineLength;
            }
            this.mUnfinishedLine = ((String)s11).substring(start);
            if (!this.mArray.isEmpty()) {
                String[] lines = this.mArray.toArray(new String[0]);
                this.processNewLines(lines);
            }
        }
    }

    @Override
    public void flush() {
        if (this.mUnfinishedLine != null) {
            this.processNewLines(new String[]{this.mUnfinishedLine});
        }
        this.done();
    }

    public void done() {
    }

    public abstract void processNewLines(String[] var1);
}

