/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import shadow.bundletool.com.android.annotations.concurrency.Slow;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.AdbHelper;
import shadow.bundletool.com.android.ddmlib.AvdData;
import shadow.bundletool.com.android.ddmlib.Client;
import shadow.bundletool.com.android.ddmlib.FileListingService;
import shadow.bundletool.com.android.ddmlib.IShellEnabledDevice;
import shadow.bundletool.com.android.ddmlib.IShellOutputReceiver;
import shadow.bundletool.com.android.ddmlib.IUserDataMap;
import shadow.bundletool.com.android.ddmlib.InstallException;
import shadow.bundletool.com.android.ddmlib.InstallMetrics;
import shadow.bundletool.com.android.ddmlib.InstallReceiver;
import shadow.bundletool.com.android.ddmlib.ProfileableClient;
import shadow.bundletool.com.android.ddmlib.RawImage;
import shadow.bundletool.com.android.ddmlib.ScreenRecorderOptions;
import shadow.bundletool.com.android.ddmlib.ServiceInfo;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.SimpleConnectedSocket;
import shadow.bundletool.com.android.ddmlib.SyncException;
import shadow.bundletool.com.android.ddmlib.SyncService;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.clientmanager.DeviceClientManager;
import shadow.bundletool.com.android.ddmlib.log.LogReceiver;
import shadow.bundletool.com.android.sdklib.AndroidVersion;

public interface IDevice
extends IShellEnabledDevice,
IUserDataMap {
    public static final String UNKNOWN_PACKAGE = "";
    public static final String RE_EMULATOR_SN = "emulator-(\\d+)";
    public static final String PROP_BUILD_VERSION = "ro.build.version.release";
    public static final String PROP_BUILD_API_LEVEL = "ro.build.version.sdk";
    public static final String PROP_BUILD_CODENAME = "ro.build.version.codename";
    public static final String PROP_BUILD_TAGS = "ro.build.tags";
    public static final String PROP_BUILD_TYPE = "ro.build.type";
    public static final String PROP_DEVICE_MODEL = "ro.product.model";
    public static final String PROP_DEVICE_MANUFACTURER = "ro.product.manufacturer";
    public static final String PROP_DEVICE_CPU_ABI_LIST = "ro.product.cpu.abilist";
    public static final String PROP_DEVICE_CPU_ABI = "ro.product.cpu.abi";
    public static final String PROP_DEVICE_CPU_ABI2 = "ro.product.cpu.abi2";
    public static final String PROP_BUILD_CHARACTERISTICS = "ro.build.characteristics";
    public static final String PROP_DEVICE_DENSITY = "ro.sf.lcd_density";
    public static final String PROP_DEVICE_EMULATOR_DENSITY = "qemu.sf.lcd_density";
    public static final String PROP_DEVICE_LANGUAGE = "persist.sys.language";
    public static final String PROP_DEVICE_REGION = "persist.sys.country";
    public static final String PROP_DEBUGGABLE = "ro.debuggable";
    public static final String PROP_DEVICE_BOOT_QEMU_DISPLAY_NAME = "ro.boot.qemu.display.settings.xml";
    public static final String FIRST_EMULATOR_SN = "emulator-5554";
    public static final int CHANGE_STATE = 1;
    public static final int CHANGE_CLIENT_LIST = 2;
    public static final int CHANGE_BUILD_INFO = 4;
    public static final int CHANGE_PROFILEABLE_CLIENT_LIST = 8;
    @Deprecated
    public static final String PROP_BUILD_VERSION_NUMBER = "ro.build.version.sdk";
    public static final String MNT_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    public static final String MNT_ROOT = "ANDROID_ROOT";
    public static final String MNT_DATA = "ANDROID_DATA";

    public String getSerialNumber();

    @Deprecated
    public String getAvdName();

    @Deprecated
    public String getAvdPath();

    default public ListenableFuture<AvdData> getAvdData() {
        throw new UnsupportedOperationException();
    }

    public DeviceState getState();

    @Deprecated
    public Map<String, String> getProperties();

    @Deprecated
    public int getPropertyCount();

    public String getProperty(String var1);

    public boolean arePropertiesSet();

    @Deprecated
    public String getPropertySync(String var1) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    @Deprecated
    public String getPropertyCacheOrSync(String var1) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    public boolean supportsFeature(Feature var1);

    public boolean supportsFeature(HardwareFeature var1);

    default public Map<String, ServiceInfo> services() {
        throw new UnsupportedOperationException();
    }

    public String getMountPoint(String var1);

    public boolean isOnline();

    public boolean isEmulator();

    public boolean isOffline();

    public boolean isBootLoader();

    public boolean hasClients();

    public Client[] getClients();

    public Client getClient(String var1);

    default public ProfileableClient[] getProfileableClients() {
        return new ProfileableClient[0];
    }

    default public DeviceClientManager getClientManager() {
        String message2 = String.format("%s is not supported", DeviceClientManager.class.getSimpleName());
        throw new UnsupportedOperationException(message2);
    }

    default public void forceStop(String applicationName) {
    }

    default public void kill(String applicationName) {
    }

    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException;

    public FileListingService getFileListingService();

    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException;

    public RawImage getScreenshot(long var1, TimeUnit var3) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void startScreenRecorder(String var1, ScreenRecorderOptions var2, IShellOutputReceiver var3) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    @Deprecated
    public void executeShellCommand(String var1, IShellOutputReceiver var2, int var3) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    public void executeShellCommand(String var1, IShellOutputReceiver var2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;

    default public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        throw new UnsupportedOperationException();
    }

    default public void executeBinderCommand(String[] parameters, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (this.supportsFeature(Feature.ABB_EXEC)) {
            this.executeRemoteCommand(AdbHelper.AdbService.ABB_EXEC, String.join((CharSequence)"\u0000", parameters), receiver, 0L, maxTimeToOutputResponse, maxTimeUnits, is2);
        } else {
            this.executeShellCommand("cmd " + String.join((CharSequence)" ", parameters), receiver, maxTimeToOutputResponse, maxTimeUnits, is2);
        }
    }

    public void runEventLogService(LogReceiver var1) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void runLogService(String var1, LogReceiver var2) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void createForward(int var1, int var2) throws TimeoutException, AdbCommandRejectedException, IOException;

    public void createForward(int var1, String var2, DeviceUnixSocketNamespace var3) throws TimeoutException, AdbCommandRejectedException, IOException;

    default public void removeForward(int localPort) throws TimeoutException, AdbCommandRejectedException, IOException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public void removeForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.removeForward(localPort);
    }

    @Deprecated
    default public void removeForward(int localPort, String remoteSocketName, DeviceUnixSocketNamespace namespace) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.removeForward(localPort);
    }

    default public void createReverse(int remotePort, int localPort) throws TimeoutException, AdbCommandRejectedException, IOException {
        throw new UnsupportedOperationException();
    }

    default public void removeReverse(int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        throw new UnsupportedOperationException();
    }

    public String getClientName(int var1);

    default public void push(String[] local, String remote) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        throw new UnsupportedOperationException();
    }

    public void pushFile(String var1, String var2) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException;

    public void pullFile(String var1, String var2) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException;

    default public SyncService.FileStat statFile(String remote) throws IOException, AdbCommandRejectedException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public void installPackage(String var1, boolean var2, String ... var3) throws InstallException;

    public void installPackage(String var1, boolean var2, InstallReceiver var3, String ... var4) throws InstallException;

    public void installPackage(String var1, boolean var2, InstallReceiver var3, long var4, long var6, TimeUnit var8, String ... var9) throws InstallException;

    public void installPackages(List<File> var1, boolean var2, List<String> var3, long var4, TimeUnit var6) throws InstallException;

    default public void installPackages(List<File> apks, boolean reinstall, List<String> installOptions) throws InstallException {
        throw new UnsupportedOperationException();
    }

    default public InstallMetrics getLastInstallMetrics() {
        throw new UnsupportedOperationException();
    }

    default public void installRemotePackages(List<String> remoteApks, boolean reinstall, List<String> installOptions, long timeout, TimeUnit timeoutUnit) throws InstallException {
        throw new UnsupportedOperationException();
    }

    default public void installRemotePackages(List<String> remoteApks, boolean reinstall, List<String> installOptions) throws InstallException {
        throw new UnsupportedOperationException();
    }

    public String syncPackageToDevice(String var1) throws TimeoutException, AdbCommandRejectedException, IOException, SyncException;

    public void installRemotePackage(String var1, boolean var2, String ... var3) throws InstallException;

    public void installRemotePackage(String var1, boolean var2, InstallReceiver var3, String ... var4) throws InstallException;

    public void installRemotePackage(String var1, boolean var2, InstallReceiver var3, long var4, long var6, TimeUnit var8, String ... var9) throws InstallException;

    public void removeRemotePackage(String var1) throws InstallException;

    public String uninstallPackage(String var1) throws InstallException;

    public String uninstallApp(String var1, String ... var2) throws InstallException;

    public void reboot(String var1) throws TimeoutException, AdbCommandRejectedException, IOException;

    public boolean root() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    public boolean isRoot() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    @Deprecated
    public Integer getBatteryLevel() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    @Deprecated
    public Integer getBatteryLevel(long var1) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException;

    public Future<Integer> getBattery();

    public Future<Integer> getBattery(long var1, TimeUnit var3);

    public List<String> getAbis();

    public int getDensity();

    public String getLanguage();

    public String getRegion();

    public AndroidVersion getVersion();

    default public void executeRemoteCommand(String command, IShellOutputReceiver rcvr, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        throw new UnsupportedOperationException();
    }

    default public void executeRemoteCommand(String command, IShellOutputReceiver rcvr, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        throw new UnsupportedOperationException();
    }

    default public void executeRemoteCommand(AdbHelper.AdbService adbService, String command, IShellOutputReceiver rcvr, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        throw new UnsupportedOperationException();
    }

    @Slow
    default public void executeRemoteCommand(AdbHelper.AdbService adbService, String command, IShellOutputReceiver rcvr, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        throw new UnsupportedOperationException();
    }

    default public SocketChannel rawExec(String executable, String[] parameters) throws AdbCommandRejectedException, TimeoutException, IOException {
        throw new UnsupportedOperationException();
    }

    default public SimpleConnectedSocket rawExec2(String executable, String[] parameters) throws AdbCommandRejectedException, TimeoutException, IOException {
        throw new UnsupportedOperationException();
    }

    default public SocketChannel rawBinder(String service, String[] parameters) throws AdbCommandRejectedException, TimeoutException, IOException {
        throw new UnsupportedOperationException();
    }

    default public Set<String> getHardwareCharacteristics() throws Exception {
        String characteristics = this.getProperty(PROP_BUILD_CHARACTERISTICS);
        if (characteristics == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Iterable)Splitter.on((char)',').split((CharSequence)characteristics));
    }

    @Override
    default public <T> T computeUserDataIfAbsent(IUserDataMap.Key<T> key, Function<IUserDataMap.Key<T>, T> mappingFunction) {
        throw new UnsupportedOperationException("Operation is not supported on this instance");
    }

    @Override
    default public <T> T getUserDataOrNull(IUserDataMap.Key<T> key) {
        throw new UnsupportedOperationException("Operation is not supported on this instance");
    }

    @Override
    default public <T> T removeUserData(IUserDataMap.Key<T> key) {
        throw new UnsupportedOperationException("Operation is not supported on this instance");
    }

    public static enum Feature {
        SCREEN_RECORD,
        PROCSTATS,
        ABB_EXEC,
        REAL_PKG_NAME,
        SKIP_VERIFICATION,
        SHELL_V2;

    }

    public static enum DeviceUnixSocketNamespace {
        ABSTRACT("localabstract"),
        FILESYSTEM("localfilesystem"),
        RESERVED("localreserved");

        private String mType;

        private DeviceUnixSocketNamespace(String type) {
            this.mType = type;
        }

        public String getType() {
            return this.mType;
        }
    }

    public static enum DeviceState {
        BOOTLOADER("bootloader"),
        FASTBOOTD("fastbootd"),
        OFFLINE("offline"),
        ONLINE("device"),
        RECOVERY("recovery"),
        SIDELOAD("sideload"),
        UNAUTHORIZED("unauthorized"),
        DISCONNECTED("disconnected");

        private String mState;

        private DeviceState(String state) {
            this.mState = state;
        }

        public static DeviceState getState(String state) {
            for (DeviceState deviceState : DeviceState.values()) {
                if (!deviceState.mState.equals(state)) continue;
                return deviceState;
            }
            return null;
        }

        public String getState() {
            return this.mState;
        }
    }

    public static enum HardwareFeature {
        WATCH("watch"),
        EMBEDDED("embedded"),
        TV("tv"),
        AUTOMOTIVE("automotive");

        private final String mCharacteristic;

        private HardwareFeature(String characteristic) {
            this.mCharacteristic = characteristic;
        }

        public String getCharacteristic() {
            return this.mCharacteristic;
        }
    }
}

