/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;

public class SdkAndroidManifestValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        this.validateNoSdkLibraryElement(manifest);
        this.validateNoSdkPatchVersionMetadata(manifest);
        this.validateInternalOnlyIfInstallLocationSet(manifest);
        this.validateNoPermissions(manifest);
        this.validateNoSharedUserId(manifest);
        this.validateNoComponents(manifest);
        this.validateNoSplitId(manifest);
        SdkAndroidManifestValidator.validateTargetSdkVersion(manifest);
    }

    private void validateNoSdkLibraryElement(AndroidManifest manifest) {
        if (!manifest.getSdkLibraryElements().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "sdk-library").build();
        }
    }

    private void validateNoSdkPatchVersionMetadata(AndroidManifest manifest) {
        if (manifest.getSdkPatchVersionMetadata().isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared with name='%s' in the manifest of an SDK bundle.", "meta-data", "shadow.bundletool.com.android.vending.sdk.version.patch").build();
        }
    }

    private void validateInternalOnlyIfInstallLocationSet(AndroidManifest manifest) {
        if (manifest.getInstallLocationValue().isPresent() && !manifest.getInstallLocationValue().get().equals("internalOnly")) {
            throw InvalidBundleException.builder().withUserMessage("'%s' in <manifest> must be 'internalOnly' for SDK bundles if it is set.", "installLocation").build();
        }
    }

    private void validateNoPermissions(AndroidManifest manifest) {
        if (!manifest.getPermissions().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "permission").build();
        }
        if (!manifest.getPermissionGroups().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "permission-group").build();
        }
        if (!manifest.getPermissionTrees().isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("<%s> cannot be declared in the manifest of an SDK bundle.", "permission-tree").build();
        }
    }

    private void validateNoSharedUserId(AndroidManifest manifest) {
        if (manifest.hasSharedUserId()) {
            throw InvalidBundleException.builder().withUserMessage("'%s' attribute cannot be used in the manifest of an SDK bundle.", "sharedUserId").build();
        }
    }

    private void validateNoComponents(AndroidManifest manifest) {
        if (manifest.hasComponents()) {
            throw InvalidBundleException.builder().withUserMessage("None of <%s>, <%s>, <%s>, or <%s> can be declared in the manifest of an SDK bundle.", "activity", "service", "provider", "receiver").build();
        }
    }

    private void validateNoSplitId(AndroidManifest manifest) {
        if (manifest.getSplitId().isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("'split' attribute cannot be used in the manifest of an SDK bundle.").build();
        }
    }

    private static void validateTargetSdkVersion(AndroidManifest manifest) {
        if (!manifest.getTargetSdkVersion().isPresent() || manifest.getTargetSdkVersion().get() < 34) {
            throw InvalidBundleException.builder().withUserMessage("The 'targetSdkVersion' of an SDK bundle should be 34 or higher.").build();
        }
    }
}

